<?php
/* ===================================================================================== */
/* AnalyseComplexe.php : Recherche multi-critres                                        */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML et remplacement des flches gauche et droite     */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction CheckDate2 par ControleDate                */
/* Version   : 1.2           Date : 07-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit Mozilla                                                  */
/* Version   : 1.3           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Interdiction de saisir des espaces dans les montants                   */
/* Version   : 1.4           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.5           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Exportation de donnes dans un fichier                                 */
/*                Ajout de slection sur le type de mouvement et la comptabilisation     */
/*                Somme des montants si oprations toutes de mme devise                 */
/* Version   : 1.6           Date : 05-09-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Correction de bug provoqu lors d'une recherche multi-critres par la  */
/*                slection d'une rubrique budgtaire (constitution de la requte SQL)   */
/* Version   : 1.7           Date : 17-10-2005        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Correction de bug provoqu lors d'une recherche multi-critres par la  */
/*                slection d'une date de transaction ou date de valeur                  */
/* Version   : 1.8           Date : 18-10-2005        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.9           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.9";

$titre="Analyse multi-critres";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);      //Connexion et Slection de la base de donnes

/* ---------------------------------------------------------------------------------------- */
/* Configuration du fichier d'exportation :                                                 */
/*   - si les paramtres n'existent pas (fichier ConfigExport.ini, les crer par dfaut     */
/*   - les rcuprer et les charger en variables de session                                 */
/* ---------------------------------------------------------------------------------------- */
 if (!file_exists("Includes/ConfigExport.ini")) {
  if (!$fConfigExport=fopen("Includes/ConfigExport.ini","w")) {
   echo "EasyCompte n'a pas russi  ouvrir le fichier de configuration d'exportation de fichiers.";exit;
  }
  fwrite($fConfigExport,"Configuration d'exportation de fichiers,tab,point");
  if (!fclose($fConfigExport)) {
   $Msg="Problme  la fermeture du fichier de configuration d'exportation de fichiers.";break;
  }
 }
 if (!$fConfigExport=fopen("Includes/ConfigExport.ini","r")) {
  echo "EasyCompte n'a pas russi  accder  la configuration d'exportation de fichiers.";exit;
 }
 while ($Record = fgetcsv ($fConfigExport, 100, ",")) {
  if ($Record[0]=="Configuration d'exportation de fichiers") {
   $sepChamp=$Record[1];$sepDecimal=$Record[2];
   break;
  }
 }
 fclose ($fConfigExport);
 switch ($sepChamp) {
  case "tab":$sepChamp="\t";break;
  case "virgule":$sepChamp=",";break;
  case "point virgule":$sepChamp=";";break;
 }
 switch ($sepDecimal) {
  case "point":$sepDecimal=".";break;
  case "virgule":$sepDecimal=",";break;
 }
 $_SESSION['sepChamp']=$sepChamp;$_SESSION['sepDecimal']=$sepDecimal;
/* ---------------------------------------------------------------------------------------- */
/* Initialisation des variables de session ou des champs de formulaire, selon.              */
/* ---------------------------------------------------------------------------------------- */
if (isset($_POST['Appel'])) {              //bouton Rechercher
 $Appel=$_POST['Appel'];
 $RecLibMvtOp=$_POST['RecLibMvtOp'];
 $RecLibMvt=StripSlashes($_POST['RecLibMvt']);
 $RecMotMvtOp=$_POST['RecMotMvtOp'];
 $RecMotMvt=StripSlashes($_POST['RecMotMvt']);
 $RecIdCpt=$_POST['RecIdCpt'];
 $RecSensMvt=$_POST['RecSensMvt'];
 $RecMajSolde=$_POST['RecMajSolde'];
 $RecIdTypMvt=$_POST['RecIdTypMvt'];
 $RecIdModRegl=$_POST['RecIdModRegl'];
 $RecIdNature=$_POST['RecIdNature'];
 $RecDateMvtDeb=$_POST['RecDateMvtDeb'];
 $RecDateMvtFin=$_POST['RecDateMvtFin'];
 $RecDateValDeb=$_POST['RecDateValDeb'];
 $RecDateValFin=$_POST['RecDateValFin'];
 $RecMntMvtDeb=$_POST['RecMntMvtDeb'];
 $RecMntMvtFin=$_POST['RecMntMvtFin'];
 $Exporter=(isset($_POST['Exporter']))?$_POST['Exporter']:false;
 $NomFichier=$_POST['NomFichier'];
 $SuffixeFichier=$_POST['SuffixeFichier'];
} else {
 if (isset($_GET['Appel'])) {              //Retour de Dtail ou Configuration
  $Appel=$_GET['Appel'];
  $RecLibMvtOp=$_SESSION['RecLibMvtOp'];
  $RecLibMvt=$_SESSION['RecLibMvt'];
  $RecMotMvtOp=$_SESSION['RecMotMvtOp'];
  $RecMotMvt=$_SESSION['RecMotMvt'];
  $RecIdCpt=$_SESSION['RecIdCpt'];
  $RecSensMvt=$_SESSION['RecSensMvt'];
  $RecMajSolde=$_SESSION['RecMajSolde'];
  $RecIdTypMvt=$_SESSION['RecIdTypMvt'];
  $RecIdModRegl=$_SESSION['RecIdModRegl'];
  $RecIdNature=$_SESSION['RecIdNature'];
  $RecDateMvtDeb=$_SESSION['RecDateMvtDeb'];
  $RecDateMvtFin=$_SESSION['RecDateMvtFin'];
  $RecDateValDeb=$_SESSION['RecDateValDeb'];
  $RecDateValFin=$_SESSION['RecDateValFin'];
  $RecMntMvtDeb=$_SESSION['RecMntMvtDeb'];
  $RecMntMvtFin=$_SESSION['RecMntMvtFin'];
  $Exporter=$_SESSION['Exporter'];
  $NomFichier=$_SESSION['NomFichier'];
  $SuffixeFichier=$_SESSION['SuffixeFichier'];
 } else {                                    //Premier accs  recherche
   $Appel="";$RecLibMvtOp="";$RecLibMvt="";$RecMotMvtOp="";$RecMotMvt="";$RecIdCpt="";$RecSensMvt="";$RecMajSolde="";
   $RecIdTypMvt="";$RecIdModRegl="";$RecIdNature="";$RecDateMvtDeb="";$RecDateMvtFin="";$RecDateValDeb="";$RecDateValFin="";
   $RecMntMvtDeb="";$RecMntMvtFin="";$Exporter=false;$NomFichier="";$SuffixeFichier="";
 }
}
$_SESSION['RecLibMvtOp']=$RecLibMvtOp;$_SESSION['RecLibMvt']=$RecLibMvt;
$_SESSION['RecMotMvtOp']=$RecMotMvtOp;$_SESSION['RecMotMvt']=$RecMotMvt;
$_SESSION['RecIdCpt']=$RecIdCpt;$_SESSION['RecSensMvt']=$RecSensMvt;$_SESSION['RecMajSolde']=$RecMajSolde;
$_SESSION['RecIdTypMvt']=$RecIdTypMvt;$_SESSION['RecIdModRegl']=$RecIdModRegl;$_SESSION['RecIdNature']=$RecIdNature;
$_SESSION['RecDateMvtDeb']=$RecDateMvtDeb;$_SESSION['RecDateMvtFin']=$RecDateMvtFin;
$_SESSION['RecDateValDeb']=$RecDateValDeb;$_SESSION['RecDateValFin']=$RecDateValFin;
$_SESSION['RecMntMvtDeb']=$RecMntMvtDeb;$_SESSION['RecMntMvtFin']=$RecMntMvtFin;
$_SESSION['Exporter']=$Exporter;$_SESSION['NomFichier']=$NomFichier;
$_SESSION['SuffixeFichier']=$SuffixeFichier;

/* ---------------------------------------------------------------------------------------- */
/* Affichage d'une transaction retenue                                                      */
/* ---------------------------------------------------------------------------------------- */
function affMvt($Exporter,$fExport,$IdMvt,$IntCpt,$DateMvt,$LibMvt,$Depense,$Recette,$Arch) {
 global $bgcolor;global $i;global $AnalyseComplexe;global $Pointbleu;global $Pointrouge;global $Check;
 global $TotDepense;global $TotRecette;
 $bgcolor == "#99CCFF" ? $bgcolor="#CCFFFF" : $bgcolor="#99CCFF"; ?>
 <tr bgcolor="<?php echo $bgcolor; ?>">
  <td class=tdcenter>
   <a href="AnalyseComplexeMouvement.php?PosAnaCplMvt=<?php echo $i; ?>" title="Accs  la transaction"
     onMouseOver="document.images.puce_<?php echo $i; ?>.src='<?php echo $Pointrouge; ?>'"
     onMouseOut="document.images.puce_<?php echo $i; ?>.src='<?php echo $Pointbleu; ?>'">
     <img id="puce_<?php echo $i; ?>" border=0 width=12 height=12 src="<?php echo $Pointbleu; ?>" name="puce_<?php echo $i; ?>" alt="pointbleu"></a>
  <td class=tdleft><?php echo $IntCpt; ?></td>
  <td class=tdleft><?php echo invDate($DateMvt,"-","JMAA"); ?></td>
  <td class=tdleft><?php echo $LibMvt; ?></td>
  <td class=tdright>
   <?php if ($Depense!=0) echo number_format($Depense,'2','.',' ')," "; ?></td>
  <td class=tdright>
   <?php if ($Recette!=0) echo number_format($Recette,'2','.',' ')," "; ?></td>
  <td class=tdcenter>
   <?php if ($Arch=='O') { ?>
       <img border=0 width=12 height=12 src="<?php echo $Check; ?>" alt="Check"><?php
      } ?></td>
 </tr><?php
 $enreg=$IntCpt.$_SESSION['sepChamp'].$DateMvt.$_SESSION['sepChamp'].$LibMvt.$_SESSION['sepChamp'];
 if ($Depense!=0) $enreg.=number_format($Depense,'2',$_SESSION['sepDecimal'],'');
 $enreg.=$_SESSION['sepChamp'];
 if ($Recette!=0) $enreg.=number_format($Recette,'2',$_SESSION['sepDecimal'],'');
 $enreg.=$_SESSION['sepChamp'].$Arch."\n";
 if ($Exporter) fwrite($fExport,$enreg);
 $AnalyseComplexe[$i++]=$IdMvt;$TotDepense=$TotDepense+$Depense;$TotRecette=$TotRecette+$Recette;
}
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des comptes pour liste droulante: $rsCompte                                */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdCpt,IntCpt FROM Compte WHERE UsCpt='A' ORDER BY NumOrd";
  $rsCompte=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des types de mouvement pour liste droulante: $rsTypeMvt                    */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdTypMvt,LibTypMvt FROM TypeMouvement ORDER BY LibTypMvt";
  $rsTypeMvt=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des modes de rglement pour liste droulante: $rsModeRegl                   */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdModRegl,LibModRegl FROM ModeReglement ORDER BY LibModRegl";
  $rsModeRegl=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubriques budgtaires pour liste droulante : $rsRubriques              */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdNature,LibNature FROM Rubrique ORDER BY LibNature";
  $rsRubriques=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Constitution de la requte : $strWhere                                                   */
/* ---------------------------------------------------------------------------------------- */
$strWhere="";
switch ($RecLibMvtOp) {
 case "=":$strWhere=$strWhere."AND LibMvt='".AddSlashes($RecLibMvt)."' ";break;
 case "like":$strWhere=$strWhere."AND LibMvt like '%".AddSlashes($RecLibMvt)."%' ";break;
 default:
}
switch ($RecMotMvtOp) {
 case "=":$strWhere=$strWhere."AND MotMvt='".AddSlashes($RecMotMvt)."' ";break;
 case "like":$strWhere=$strWhere."AND MotMvt like '%".AddSlashes($RecMotMvt)."%' ";break;
 default:
}
switch ($RecIdCpt) {
 case "":break;
 default:$strWhere=$strWhere."AND Compte.IdCpt='".$RecIdCpt."' ";break;
}
switch ($RecSensMvt) {
 case "":break;
 default:$strWhere=$strWhere."AND SensMvt='".$RecSensMvt."' ";break;
}
switch ($RecIdTypMvt) {
 case "":break;
 default:$strWhere.="AND TypMvt='".$RecIdTypMvt."' ";break;
}
switch ($RecIdModRegl) {
 case "":break;
 default:$strWhere=$strWhere."AND ModMvt='".$RecIdModRegl."' ";break;
}
switch ($RecIdNature) {
 case "":break;
 default:$strWhere=$strWhere."AND IdNature='".$RecIdNature."' ";break;
}
if ($RecDateMvtDeb<>"") {
 if ($RecDateMvtDeb==$RecDateMvtFin) $strWhere=$strWhere."AND DateMvt='".invDate($RecDateMvtDeb,'-','AAMJ')."' ";
 else $strWhere=$strWhere."AND DateMvt>='".invDate($RecDateMvtDeb,'-','AAMJ')."' AND DateMvt<='".invDate($RecDateMvtFin,'-','AAMJ')."' ";
}
if ($RecDateValDeb<>"") {
 if ($RecDateValDeb==$RecDateValFin) $strWhere=$strWhere."AND DateVal='".invDate($RecDateValDeb,'-','AAMJ')."' ";
 else $strWhere=$strWhere."AND DateVal>='".invDate($RecDateValDeb,'-','AAMJ')."' AND DateVal<='".invDate($RecDateValFin,'-','AAMJ')."' ";
}
if ($RecMntMvtDeb<>"") {
 if ($RecMntMvtDeb==$RecMntMvtFin) $strWhere=$strWhere."AND MntMvt=".$RecMntMvtDeb." ";
 else $strWhere=$strWhere."AND MntMvt>=".$RecMntMvtDeb." AND MntMvt<=".$RecMntMvtFin." ";
}

$ExportPossible=$Exporter;	//si case Exporter coche, Export  priori possible
if ($Appel=="R" or $Appel=="D" or $Appel=="C") { //Rechercher ou retour de dtail ou de Configuration
  $strWhereArch=$strWhere;
/* ---------------------------------------------------------------------------------------- */
/* Complment  la requte strWhere                                                         */
/* ---------------------------------------------------------------------------------------- */
  if ($RecMajSolde<>"") $strWhere.="AND MajSolde='".$RecMajSolde."' ";
  if ($RecIdNature=="") { $strFromCplt=" ";$strJoinCplt=" "; }
  else { $strFromCplt=",MouvementRubrique ";$strJoinCplt="AND Mouvement.IdMvt=MouvementRubrique.IdMvt "; }
/* ---------------------------------------------------------------------------------------- */
/* Complment  la requte strWhereArch                                                     */
/* ---------------------------------------------------------------------------------------- */
  if ($RecMajSolde=="N") $strWhereArch="AND 0 ";
  if ($RecIdNature=="") { $strFromCpltArch=" ";$strJoinCpltArch=" "; }
  else { $strFromCpltArch=",CompteReleveMouvementRubrique ";
         $strJoinCpltArch="AND CompteReleveMouvement.IdMvt=CompteReleveMouvementRubrique.IdMvt ";
  }

  if ($strWhere=="" or $strWhereArch=="") {
   $Msg="Veuillez renseigner au moins un critre de slection.";
   $ExportPossible=false;
  }
  else {
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des transactions rpondant aux critres de recherche : $rsMouvement         */
/* ---------------------------------------------------------------------------------------- */
   $sql="SELECT Mouvement.IdMvt,IntCpt,IdDevise,DateMvt,LibMvt,MntMvt*(SensMvt='D') as Depense,MntMvt*(SensMvt='R') as Recette ";
   $sql=$sql."FROM Compte,Mouvement".$strFromCplt;
   $sql=$sql."WHERE Compte.IdCpt=Mouvement.IdCpt ".$strJoinCplt.$strWhere;
   $sql=$sql."ORDER BY DateMvt,IdMvt";
   $rsMouvement=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des transactions archives rpondant aux critres de recherche              */
/*                                                                       : $rsMouvementArch */
/* ---------------------------------------------------------------------------------------- */
   $sql="SELECT CompteReleveMouvement.IdMvt,IntCpt,IdDevise,DateMvt,LibMvt,MntMvt*(SensMvt='D') as Depense,MntMvt*(SensMvt='R') as Recette ";
   $sql=$sql."FROM Compte,CompteReleveMouvement".$strFromCpltArch;
   $sql=$sql."WHERE Compte.IdCpt=CompteReleveMouvement.IdCpt ".$strJoinCpltArch.$strWhereArch;
   $sql=$sql."ORDER BY DateMvt,IdMvt";
   $rsMouvementArch=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Cration ventuelle du fichier d'exportation des donnes                                 */
/* ---------------------------------------------------------------------------------------- */
   $fExport="";$nomFichierComplet="";
   if ($Exporter) {
    $Path="Export/";
    if (!is_dir($Path)) mkdir($Path,777);
    $nomFichierComplet=$Path.$NomFichier;
    if ($SuffixeFichier!="") $nomFichierComplet.=".".$SuffixeFichier;
    if (!$fExport=@fopen($nomFichierComplet,"w")) {
     $Msg="Problme  l'ouverture du fichier <u>".$nomFichierComplet;
     $Msg.="</u><br>Son nom n'est peut-tre pas correct ou ce dernier est sans doute dj ouvert par une autre application.";
     $ExportPossible=false;
    }
   }
   if ($ExportPossible) {
    $intitules="Compte".$_SESSION['sepChamp']."Date".$_SESSION['sepChamp']."Intitul".$_SESSION['sepChamp']."Dpense".$_SESSION['sepChamp'];
    $intitules.="Recette".$_SESSION['sepChamp']."Archiv";
    fwrite($fExport,$intitules."\n");
   }
  }
} ?>

<HTML>
<HEAD>
<TITLE>Analyse des transactions multi-critres</TITLE>
<META name="description" content="Analyse des transactions multi-critres">
<META name="keywords" content="">
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">
<script language="javascript">
<?php include("./Includes/ControleDate.js");    //ControleDate(d) : Contrle du format JJ-MM-AAAA de la date d
   include("./Includes/AddDelai.js");        //AddDelai(d,D) : Retourne une date au format JJ-MM-AAAA en ajoutant un dlai D (nombre de jours)  une date d au format JJ-MM-AAAA
?>
/* ---------------------------------------------------------------------------------------- */
/* Contrle des valeurs des champs du formulaire                                            */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(form) {
 if (form.RecLibMvt.value.indexOf('%')!=-1) {
  alert("La recherche ne peut s'effectuer sur un critre comportant le caractre %")
  form.RecLibMvt.focus()
  return false
 }
 if (form.RecMotMvt.value.indexOf('%')!=-1) {
  alert("La recherche ne peut s'effectuer sur un critre comportant le caractre %")
  form.RecMotMvt.focus()
  return false
 }
 if (form.RecDateMvtDeb.value!='') {
  datemvtdeb=ControleDate(form.RecDateMvtDeb.value); 
  if (!datemvtdeb) {
   alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   form.RecDateMvtDeb.focus();
   return false;
  }
  if (form.RecDateMvtFin.value=="") form.RecDateMvtFin.value=form.RecDateMvtDeb.value;
 }
 if (form.RecDateMvtFin.value!='') {
  datemvtfin=ControleDate(form.RecDateMvtFin.value); 
  if (!datemvtfin) {
   alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   form.RecDateMvtFin.focus();
   return false;
  }
  if (form.RecDateMvtDeb.value=="") {
   form.RecDateMvtDeb.value=form.RecDateMvtFin.value;
   datemvtdeb=datemvtfin; 
  }
 }
 if (form.RecDateMvtDeb.value!='') {
  if (datemvtdeb>datemvtfin) {
   alert("La date de dbut de recherche doit tre antrieure  celle de fin de recherche");
   form.RecDateMvtDeb.focus();
   return false;
  }
 }
 if (form.RecDateValDeb.value!='') {
  datevaldeb=ControleDate(form.RecDateValDeb.value); 
  if (!datevaldeb) {
   alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   form.RecDateValDeb.focus();
   return false;
  }
  if (form.RecDateValFin.value=="") form.RecDateValFin.value=form.RecDateValDeb.value;
 }
 if (form.RecDateValFin.value!='') {
  datevalfin=ControleDate(form.RecDateValFin.value); 
  if (!datevalfin) {
   alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   form.RecDateValFin.focus();
   return false;
  }
  if (form.RecDateValDeb.value=="") {
   form.RecDateValDeb.value=form.RecDateValFin.value;
   datevaldeb=datevalfin; 
  }
 }
 if (form.RecDateValDeb.value!='') {
  if (datevaldeb>datevalfin) {
   alert("La date de dbut de recherche doit tre antrieure  celle de fin de recherche");
   form.RecDateValDeb.focus();
   return false;
  }
 }
 form.RecMntMvtDeb.value=form.RecMntMvtDeb.value.replace(RegExp(" ","g"),"");
 form.RecMntMvtFin.value=form.RecMntMvtFin.value.replace(RegExp(" ","g"),"");
 if (form.RecMntMvtDeb.value!="") {
  if (isNaN(form.RecMntMvtDeb.value)) {
   alert("Le montant de dbut de recherche doit tre numrique")
   form.RecMntMvtDeb.focus();
   return false
  }
  if (form.RecMntMvtFin.value=="") form.RecMntMvtFin.value=form.RecMntMvtDeb.value;
 }
 if (form.RecMntMvtFin.value!="") {
  if (isNaN(form.RecMntMvtFin.value)) {
   alert("Le montant de fin de recherche doit tre numrique")
   form.RecMntMvtFin.focus();
   return false
  }
  if (form.RecMntMvtDeb.value=="") form.RecMntMvtDeb.value=form.RecMntMvtFin.value;
 }
 if (form.Exporter.checked && form.NomFichier.value=="") {
   alert("En cas d'exportation de donnes, le nom du fichier doit tre renseign")
   form.NomFichier.focus();
   return false
 }
 return true 
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE DEBUT DE RECHERCHE (DateMvt)                                    */
/* ---------------------------------------------------------------------------------------- */
function RecDateMvtDeb_Change(RecDateMvtDeb) {
 if (RecDateMvtDeb.value!='') {
  datemvtdeb=ControleDate(RecDateMvtDeb.value); 
  if (!datemvtdeb) {
   alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   RecDateMvtDeb.focus();
   return;
  }
 }
}
function RecDateMvtDeb_Moins_Click(RecDateMvtDeb) {
 datemvtdeb=ControleDate(RecDateMvtDeb.value); 
 if (!datemvtdeb) {
  alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateMvtDeb.focus();
  return; 
 }
 RecDateMvtDeb.value=AddDelai(RecDateMvtDeb.value,-1);
}
function RecDateMvtDeb_Plus_Click(RecDateMvtDeb) {
 datemvtdeb=ControleDate(RecDateMvtDeb.value); 
 if (!datemvtdeb) {
  alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateMvtDeb.focus();
  return;
 }
 RecDateMvtDeb.value=AddDelai(RecDateMvtDeb.value,1); 
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE FIN DE RECHERCHE (DateMvt)                                      */
/* ---------------------------------------------------------------------------------------- */
function RecDateMvtFin_Change(RecDateMvtFin) {
 if (RecDateMvtFin.value!='') {
  datemvtfin=ControleDate(RecDateMvtFin.value); 
  if (!datemvtfin) {
   alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   RecDateMvtFin.focus();
   return;
  } 
 } 
}
function RecDateMvtFin_Moins_Click(RecDateMvtFin) {
 datemvtfin=ControleDate(RecDateMvtFin.value); 
 if (!datemvtfin) {
  alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateMvtFin.focus();
  return;
 }
 RecDateMvtFin.value=AddDelai(RecDateMvtFin.value,-1);
}
function RecDateMvtFin_Plus_Click(RecDateMvtFin) {
 datemvtfin=ControleDate(RecDateMvtFin.value); 
 if (!datemvtfin) {
  alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateMvtFin.focus();
  return;
 }
 RecDateMvtFin.value=AddDelai(RecDateMvtFin.value,1);
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE DEBUT DE RECHERCHE (DateVal)                                    */
/* ---------------------------------------------------------------------------------------- */
function RecDateValDeb_Change(RecDateValDeb) {
 if (RecDateValDeb.value!='') {
  datevaldeb=ControleDate(RecDateValDeb.value); 
  if (!datevaldeb) {
   alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   RecDateValDeb.focus();
   return;
  }
 }
}
function RecDateValDeb_Moins_Click(RecDateValDeb) {
 datevaldeb=ControleDate(RecDateValDeb.value); 
 if (!datevaldeb) {
  alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateValDeb.focus();
  return; 
 }
 RecDateValDeb.value=AddDelai(RecDateValDeb.value,-1);
}
function RecDateValDeb_Plus_Click(RecDateValDeb) {
 datevaldeb=ControleDate(RecDateValDeb.value); 
 if (!datevaldeb) {
  alert("La date de dbut de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateValDeb.focus();
  return;
 }
 RecDateValDeb.value=AddDelai(RecDateValDeb.value,1); 
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE FIN DE RECHERCHE (DateVal)                                      */
/* ---------------------------------------------------------------------------------------- */
function RecDateValFin_Change(RecDateValFin) {
 if (RecDateValFin.value!='') {
  datevalfin=ControleDate(RecDateValFin.value); 
  if (!datevalfin) {
   alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
   RecDateValFin.focus();
   return;
  } 
 } 
}
function RecDateValFin_Moins_Click(RecDateValFin) {
 datevalfin=ControleDate(RecDateValFin.value); 
 if (!datevalfin) {
  alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateValFin.focus();
  return;
 }
 RecDateValFin.value=AddDelai(RecDateValFin.value,-1);
}
function RecDateValFin_Plus_Click(RecDateValFin) {
 datevalfin=ControleDate(RecDateValFin.value); 
 if (!datevalfin) {
  alert("La date de fin de recherche est une information  saisir obligatoirement au format JJ-MM-AAAA");
  RecDateValFin.focus();
  return;
 }
 RecDateValFin.value=AddDelai(RecDateValFin.value,1);
}
</script>
</HEAD>
<BODY onLoad="top.document.title='<?php echo AddSlashes($titre); ?>';window.defaultStatus=top.document.title">
<!-- Dbut du formulaire ---------------------------------------------------------------------->
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" onSubmit="return control_saisie(this)">
<input type="hidden" name="Appel" value="R"> <!-- Transmission  AnalyseComplexe.php -->
<a name="haut"></a>
<table>
 <tr>
  <td class=tdleft>
   <a href="ConfigExport.php" title="Configuration d'exportation de fichier">Configuration</a></td>
  <td class=tdleft>
   <a href="Help/RechercheMultiCriteres_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>
<hr size=2 width="100%"> <!------------------------------------------------------->
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>Libell</td>
  <td class=tdleft>
   <select name="RecLibMvtOp"
    onMouseOver="javascript:window.status='Slectionner le type de recherche  effectuer sur le libell de la transaction'">
	<option value="">indiffrent</option>
	<option value="=" <?php if ($RecLibMvtOp=="=") echo "selected"; ?>>gale</option>
	<option value="like" <?php if ($RecLibMvtOp=="like") echo "selected"; ?>>contient</option>
   </select>
   <INPUT TYPE="TEXT" name="RecLibMvt" SIZE="25" maxlength="30" value="<?php echo StripSlashes($RecLibMvt); ?>"
    onMouseOver="javascript:window.status='Valeur recherche pour le libell de la transaction'"></td></tr>
 <tr>
  <td class=tdleft>Motif</td>
  <td class=tdleft>
   <select name="RecMotMvtOp"
    onMouseOver="javascript:window.status='Slectionner le type de recherche  effectuer sur le motif de la transaction'">
	<option value="">indiffrent</option>
	<option value="=" <?php if ($RecMotMvtOp=="=") echo "selected"; ?>>gale</option>
	<option value="like" <?php if ($RecMotMvtOp=="like") echo "selected"; ?>>contient</option>
   </select>
   <INPUT TYPE="TEXT" name="RecMotMvt" SIZE="25" maxlength="30" value="<?php echo StripSlashes($RecMotMvt); ?>"
    onMouseOver="javascript:window.status='Valeur recherche pour le motif de la transaction'"></td></tr>
<tr>
  <td class=tdleft>Compte</td>
  <td class=tdleft>
   <select name="RecIdCpt"
    onMouseOver="javascript:window.status='Slectionner ventuellement le compte dans lequel s\'effectue la recherche'">
	<option value="">indiffrent</option><?php
     while($Compte=mysqli_fetch_array($rsCompte,MYSQLI_ASSOC)) {
      ($RecIdCpt==$Compte['IdCpt']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $Compte['IdCpt']; ?>" <?php echo $selected; ?>><?php echo $Compte['IntCpt']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Sens</td>
  <td class=tdleft>
   <select name="RecSensMvt"
    onMouseOver="javascript:window.status='Restreindre ventuellement la recherche aux dpenses ou aux recettes'">
	<option value="">indiffrent</option>
	<option value="D" <?php if ($RecSensMvt=="D") echo "selected"; ?>>Dpense</option>
	<option value="R" <?php if ($RecSensMvt=="R") echo "selected"; ?>>Recette</option>
   </select></td></tr>
 <tr>
  <td class=tdleft>Opration comptabilise</td>
  <td class=tdleft>
   <select name="RecMajSolde"
    onMouseOver="window.status='Restreindre ventuellement la recherche aux oprations compatbilises ou non'">
	<option value="">indiffrent</option>
	<option value="O" <?php if ($RecMajSolde=="O") echo "selected"; ?>>Oui</option>
	<option value="N" <?php if ($RecMajSolde=="N") echo "selected"; ?>>Non</option>
   </select></td></tr>
 <tr>
  <td class=tdleft>Type d'opration</td>
  <td class=tdleft>
   <select name="RecIdTypMvt"
    onMouseOver="window.status='Restreindre ventuellement la recherche selon le type d\'opration'">
	<option value="">indiffrent</option><?php
     while($TypeMvt=mysqli_fetch_array($rsTypeMvt,MYSQLI_ASSOC)) {
      ($RecIdTypMvt==$TypeMvt['IdTypMvt']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $TypeMvt['IdTypMvt']; ?>" <?php echo $selected; ?>><?php echo $TypeMvt['LibTypMvt']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Mode de rglement</td>
  <td class=tdleft>
   <select name="RecIdModRegl"
    onMouseOver="javascript:window.status='Restreindre ventuellement la recherche au mode de rglement utilis'">
	<option value="">indiffrent</option><?php
     while($ModeRegl=mysqli_fetch_array($rsModeRegl,MYSQLI_ASSOC)) {
      ($RecIdModRegl==$ModeRegl['IdModRegl']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $ModeRegl['IdModRegl']; ?>" <?php echo $selected; ?>><?php echo $ModeRegl['LibModRegl']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Rubrique budgtaire</td>
  <td class=tdleft>
   <select name="RecIdNature"
    onMouseOver="javascript:window.status='Restreindre ventuellement la recherche  un poste budgtaire imput'">
	<option value="">indiffrent</option><?php
     while($Rubriques=mysqli_fetch_array($rsRubriques,MYSQLI_ASSOC)) {
      ($RecIdNature==$Rubriques['IdNature']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $Rubriques['IdNature']; ?>" <?php echo $selected; ?>><?php echo $Rubriques['LibNature']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr><td>&nbsp</td></tr>
</table>
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>Date de transaction</td>
  <td class=tdleft>du &nbsp;
   <BUTTON TYPE="BUTTON" name="RecDateMvtDeb_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de dbut de recherche'"
    onClick="javascript:RecDateMvtDeb_Moins_Click(RecDateMvtDeb)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="RecDateMvtDeb" SIZE="10" maxlength="10" value="<?php echo StripSlashes($RecDateMvtDeb); ?>"
    onMouseOver="javascript:window.status='Date de dbut de recherche'"
    onChange="javascript:RecDateMvtDeb_Change(RecDateMvtDeb)">&nbsp
   <BUTTON TYPE="BUTTON" name="RecDateMvtDeb_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de dbut de recherche'"
    onClick="javascript:RecDateMvtDeb_Plus_Click(RecDateMvtDeb)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td>
  <td class=tdleft>au &nbsp;
   <BUTTON TYPE="BUTTON" name="RecDateMvtFin_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de fin de recherche'"
    onClick="javascript:RecDateMvtFin_Moins_Click(RecDateMvtFin)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="RecDateMvtFin" SIZE="10" maxlength="10" value="<?php echo StripSlashes($RecDateMvtFin); ?>"
    onMouseOver="javascript:window.status='Date de fin de recherche'"
    onChange="javascript:RecDateMvtFin_Change(RecDateMvtFin)">&nbsp
   <BUTTON TYPE="BUTTON" name="RecDateMvtFin_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de fin de recherche'"
    onClick="javascript:RecDateMvtFin_Plus_Click(RecDateMvtFin)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td></tr>
 <tr>
  <td class=tdleft>Date de valeur</td>
  <td class=tdleft>du &nbsp;
   <BUTTON TYPE="BUTTON" name="RecDateValDeb_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de dbut de recherche'"
    onClick="javascript:RecDateValDeb_Moins_Click(RecDateValDeb)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="RecDateValDeb" SIZE="10" maxlength="10" value="<?php echo StripSlashes($RecDateValDeb); ?>"
    onMouseOver="javascript:window.status='Date de dbut de recherche'"
    onChange="javascript:RecDateValDeb_Change(RecDateValDeb)">&nbsp;
   <BUTTON TYPE="BUTTON" name="RecDateValDeb_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de dbut de recherche'"
    onClick="javascript:RecDateValDeb_Plus_Click(RecDateValDeb)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td>
  <td class=tdleft>au &nbsp;
   <BUTTON TYPE="BUTTON" name="RecDateValFin_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de fin de recherche'"
    onClick="javascript:RecDateValFin_Moins_Click(RecDateValFin)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="RecDateValFin" SIZE="10" maxlength="10" value="<?php echo StripSlashes($RecDateValFin); ?>"
    onMouseOver="javascript:window.status='Date de fin de recherche'"
    onChange="javascript:RecDateValFin_Change(RecDateValFin)">&nbsp;
   <BUTTON TYPE="BUTTON" name="RecDateValFin_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de fin de recherche'"
    onClick="javascript:RecDateValFin_Plus_Click(RecDateValFin)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td></tr>
 <tr>
  <td class=tdleft>Montant</td>
  <td class=tdleft>de &nbsp;
   <INPUT TYPE="TEXT" name="RecMntMvtDeb" SIZE="17" maxlength="17" style="text-align:right" value="<?php echo StripSlashes($RecMntMvtDeb); ?>" 
    onMouseOver="javascript:window.status='Montant de dbut de recherche'"></td>
  <td class=tdleft> &nbsp;&nbsp;&nbsp;
   <INPUT TYPE="TEXT" name="RecMntMvtFin" SIZE="17" maxlength="17" style="text-align:right" value="<?php echo StripSlashes($RecMntMvtFin); ?>"
    onMouseOver="javascript:window.status='Montant de fin de recherche'"></td></tr>
 <tr><td>&nbsp</td></tr>
</table>
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>
   <INPUT TYPE="CHECKBOX" name="Exporter" <?php if ($Exporter) echo "checked"; ?>
    onMouseOver="javascript:window.status='Cocher la case pour rcuprer dans un fichier,les informations affiches'">
   Exporter le rsultat dans le fichier
   <INPUT TYPE="TEXT" name="NomFichier" SIZE="15" value="<?php echo StripSlashes($NomFichier); ?>"
    onMouseOver="window.status='Nom du fichier d\'exportation des rsultats'">&nbsp;.
   <select name="SuffixeFichier"
    onMouseOver="window.status='Type du fichier d\'exportation'">
	<option value=""    <?php if ($SuffixeFichier=="") echo "selected"; ?>></option>
	<option value="csv" <?php if ($SuffixeFichier=="csv") echo "selected"; ?>>csv</option>
	<option value="doc" <?php if ($SuffixeFichier=="doc") echo "selected"; ?>>doc</option>
	<option value="txt" <?php if ($SuffixeFichier=="txt") echo "selected"; ?>>txt</option>
	<option value="xls" <?php if ($SuffixeFichier=="xls") echo "selected"; ?>>xls</option>
   </select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php
   if ($ExportPossible) { ?>
    <a href="<?php echo $nomFichierComplet; ?>" target="_blank">
     <img src="Graphiques/Puces/fichier.png" border="0" align="middle" width="20" height="20"
      alt="fichier" title="Ouverture du fichier <?php echo $nomFichierComplet; ?>"></a></td></tr><?php
   } ?>
 <tr>
  <td class=tdleft>Renseignez le ou les critres de recherche prcdents et cliquer sur le bouton
   &nbsp;&nbsp;&nbsp;<button type="submit" name="Rechercher_button">Rechercher</button></td></tr>
</table>
<hr size=2 width="100%"> <!------------------------------------------------------->
<?php if ($Appel<>"R" and $Appel<>"D" and $Appel<>"C") exit;
   if (isset($Msg)) { ?>
    <p class=msg><?php echo $Msg; ?></p><?php
   }
   if ($strWhere=="" and $strWhereArch=="") exit; ?>
<table border=0 cellspacing=1 cellpadding=0>
 <tr>
  <th class=thcenter>&nbsp</th>
  <th class=thcenter>Compte</th>
  <th class=thcenter>Date</th>
  <th class=thcenter>Libell</th>
  <th class=thcenter>Dpense</th>
  <th class=thcenter>Recette</th>
  <th class=thcenter>Arch.</th>
 </tr>
<?php
$bgcolor="";$i=0;unset($AnalyseComplexe);$TotDepense=0;$TotRecette=0;$IdDeviseGen="";
if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE; 
if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE; 
/* ---------------------------------------------------------------------------------------- */
/* Dbut de dtection de la prsence d'oprations exprimes dans des devises diffrentes    */
/* ---------------------------------------------------------------------------------------- */
if ($rsMouvement_OK) $IdDeviseGen=$Mouvement['IdDevise'];
if ($rsMouvementArch_OK) {
 if ($IdDeviseGen=="") $IdDeviseGen=$MouvementArch['IdDevise'];
 else {
  if ($MouvementArch['IdDevise']!=$Mouvement['IdDevise']) $IdDeviseGen="";
 }
}
/* ---------------------------------------------------------------------------------------- */
/* Parcours des deux recordsets                                                             */
/* ---------------------------------------------------------------------------------------- */
while($rsMouvement_OK and $rsMouvementArch_OK) {
 if ($MouvementArch['DateMvt']<=$Mouvement['DateMvt']) {
  if ($MouvementArch['IdDevise']!=$IdDeviseGen) $IdDeviseGen="";
  affMvt($ExportPossible,$fExport,$MouvementArch['IdMvt'],$MouvementArch['IntCpt'],$MouvementArch['DateMvt'],$MouvementArch['LibMvt'],$MouvementArch['Depense'],$MouvementArch['Recette'],'O');
  if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE; 
 }
 else {
  if ($Mouvement['IdDevise']!=$IdDeviseGen) $IdDeviseGen="";
  affMvt($ExportPossible,$fExport,$Mouvement['IdMvt'],$Mouvement['IntCpt'],$Mouvement['DateMvt'],$Mouvement['LibMvt'],$Mouvement['Depense'],$Mouvement['Recette'],'N');
  if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE; 
 }
}
while($rsMouvementArch_OK) {
 if ($MouvementArch['IdDevise']!=$IdDeviseGen) $IdDeviseGen="";
 affMvt($ExportPossible,$fExport,$MouvementArch['IdMvt'],$MouvementArch['IntCpt'],$MouvementArch['DateMvt'],$MouvementArch['LibMvt'],$MouvementArch['Depense'],$MouvementArch['Recette'],'O');
 if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE; 
}
while($rsMouvement_OK) {
 if ($Mouvement['IdDevise']!=$IdDeviseGen) $IdDeviseGen="";
 affMvt($ExportPossible,$fExport,$Mouvement['IdMvt'],$Mouvement['IntCpt'],$Mouvement['DateMvt'],$Mouvement['LibMvt'],$Mouvement['Depense'],$Mouvement['Recette'],'N');
 if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE;
} 
/* ---------------------------------------------------------------------------------------- */
/* Affichage du bas de la liste                                                             */
/* ---------------------------------------------------------------------------------------- */
if (!isset($AnalyseComplexe)) { $AnalyseComplexe=Array();echo "</table><p>Aucune transaction ne rpond  ces critres de recherche</p>"; }
else { ?>
 <tr>
  <th class=thcenter>&nbsp</th>
  <th class=thcenter colspan="3"><?php echo count($AnalyseComplexe)." transactions trouves pour un total de "; ?></th>
  <th class=thcenter><?php if ($IdDeviseGen!="") echo number_format($TotDepense,'2','.',' '); ?></th>
  <th class=thcenter><?php if ($IdDeviseGen!="") echo number_format($TotRecette,'2','.',' '); ?></th>
  <th class=thcenter>&nbsp</th>
 </tr><?php
 if ($IdDeviseGen=="") { ?>
  <tr><td class=tdleft colspan="7"><p class=msg><?php echo "Attention : Prsence d'oprations exprimes dans des devises diffrentes"; ?></p></td></tr><?php
  if ($ExportPossible) fwrite($fExport,"Attention : Prsence d'oprations exprimes dans des devises diffrentes\n");
 } ?>
 <tr><td class=tdleft colspan="7"><br><a href="#haut" title="top">retour aux critres de slection</a></td></tr><?php
} 
if ($ExportPossible) {
 if (!fclose($fExport))
  $Msg="Problme  la fermeture du fichier d'exportation des donnes";
}
$_SESSION['AnalyseComplexe']=$AnalyseComplexe; ?>
</table>

</form>
</BODY>
</HTML>
