<?php
/* ===================================================================================== */
/* AnalysePostes.php : Analyse budgtaire par postes                                     */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML et remplacement des flches gauche et droite     */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction CheckDate par ControleDate                 */
/* Version   : 1.2           Date : 07-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de la reprsentation graphique sous forme de secteurs            */
/* Version   : 1.3           Date : 12-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit Mozilla                                                  */
/* Version   : 1.4           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.5           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Dtection de la bibliothque GD des fonctions graphiques               */
/* Version   : 1.6           Date : 02-02-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.7           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.7";

$titre="Analyse budgtaire";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
include("./Includes/Draw_Secteurs.php");   //illustration de statistiques sous forme de secteurs
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);      //Connexion et Slection de la base de donnes

if (isset($_POST['DateDeb'])) { $DateDeb=$_POST['DateDeb'];$DateFin=$_POST['DateFin']; }
else {
 if (isset($_SESSION['DateDeb'])) { $DateDeb=$_SESSION['DateDeb'];$DateFin=$_SESSION['DateFin']; }
 else {
  $DateDeb=date("d-m-Y",mktime(0,0,0,date("m"),1,date("Y")-1));
  $DateFin=date("d-m-Y",mktime(0,0,0,date("m"),1,date("Y"))-24*3600);
 }
}
$_SESSION['DateDeb']=$DateDeb;$_SESSION['DateFin']=$DateFin;
$invDateFin=invDate($DateFin,'-','AAMJ');$invDateDeb=invDate($DateDeb,'-','AAMJ');

/* ---------------------------------------------------------------------------------------- */
/* Rcupration de la devise de rfrence : $DeviseRefer                                    */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdDevise,Format,Taux FROM Devise WHERE Reference='O'";$rsDeviseRefer=send_sql($dblk, $sql);
  if (!$DeviseRefer=mysqli_fetch_array($rsDeviseRefer,MYSQLI_ASSOC)) { ?>
   <h1>Devise de rfrence non dfinie</h1>
   <P>L'analyse des postes budgtaires ncessite la conversion des montants des diffrentes transactions dans une devise identique.<br>
      Il convient de dfinir cette devise de rfrence dans la gestion des <a href="Devises.php">Devises</a>. 
   </p><?php exit;
  }
  $DeviseReferTaux=$DeviseRefer['Taux'];
/* ---------------------------------------------------------------------------------------- */
/* Rpartition des mouvements par postes budgtaires : $rsMouvement                         */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Rubrique.NumOrd,Rubrique.IdNature,Taux,SUM(MntImp*(SensMvt='D')/Taux*$DeviseReferTaux) as TotalDepense";
  $sql.=",SUM(MntImp*(SensMvt='R')/Taux*$DeviseReferTaux) as TotalRecette ";
  $sql.="FROM Compte,Devise,Rubrique,Mouvement,MouvementRubrique ";
  $sql.="WHERE Mouvement.IdMvt=MouvementRubrique.IdMvt ";
  $sql.="and Compte.IdCpt=Mouvement.IdCpt and Compte.IdDevise=Devise.IdDevise ";
  $sql.="and Rubrique.IdNature=MouvementRubrique.IdNature and DateMvt>='".$invDateDeb."' and DateMvt<='".$invDateFin."' ";
  $sql.="GROUP BY Rubrique.IdNature ORDER BY Rubrique.NumOrd,Rubrique.IdNature";
//echo "sql=".$sql."<br>";
  $rsMouvement=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rpartition des mouvements archivs par postes budgtaires : $rsMouvementArch            */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Rubrique.NumOrd,Rubrique.IdNature,Taux,SUM(MntImp*(SensMvt='D')/Taux*$DeviseReferTaux) as TotalDepense,SUM(MntImp*(SensMvt='R')/Taux*$DeviseReferTaux) as TotalRecette ";
  $sql.="FROM Compte,Devise,Rubrique,CompteReleveMouvement,CompteReleveMouvementRubrique ";
  $sql.="WHERE Rubrique.IdNature=CompteReleveMouvementRubrique.IdNature ";
  $sql.="and CompteReleveMouvement.IdMvt=CompteReleveMouvementRubrique.IdMvt ";
  $sql.="and CompteReleveMouvement.IdCpt=Compte.IdCpt and Compte.IdDevise=Devise.IdDevise ";
  $sql.="and DateMvt>='".$invDateDeb."' and DateMvt<='".$invDateFin."' ";
  $sql.="GROUP BY Rubrique.IdNature ORDER BY NumOrd,Rubrique.IdNature";
  $rsMouvementArch=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Calcul des montants des transactions passes sur la mme priode : $TotMouvement         */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Sum(MntMvt*(SensMvt='D')/Taux*$DeviseReferTaux) as Depense,Sum(MntMvt*(SensMvt='R')/Taux*$DeviseReferTaux) as Recette ";
  $sql.="FROM Compte,Devise,Mouvement ";
  $sql.="WHERE Compte.IdCpt=Mouvement.IdCpt and Compte.IdDevise=Devise.IdDevise ";
  $sql.="and DateMvt>='".$invDateDeb."' and DateMvt<='".$invDateFin."' ";
  $rsTotMouvement=send_sql($dblk, $sql);$TotMouvement=mysqli_fetch_array($rsTotMouvement,MYSQLI_ASSOC);
/* ---------------------------------------------------------------------------------------- */
/* Calcul des montants des transactions archives passes sur la mme priode :             */
/*                                                                       $TotMouvementArch  */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Sum(MntMvt*(SensMvt='D')/Taux*$DeviseReferTaux) as Depense,Sum(MntMvt*(SensMvt='R')/Taux*$DeviseReferTaux) as Recette ";
  $sql.="FROM Compte,Devise,CompteReleveMouvement ";
  $sql.="WHERE Compte.IdCpt=CompteReleveMouvement.IdCpt and Compte.IdDevise=Devise.IdDevise ";
  $sql.="and DateMvt>='".$invDateDeb."' and DateMvt<='".$invDateFin."' ";
  $rsTotMouvementArch=send_sql($dblk, $sql);$TotMouvementArch=mysqli_fetch_array($rsTotMouvementArch,MYSQLI_ASSOC);
?> 
<HTML>
<HEAD>
<TITLE>Analyse des transactions par poste budgtaire</TITLE>
<meta name="content-type" content="image/png">
<META name="description" content="Analyse des transactions par poste budgtaire">
<META name="keywords" content="">
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">
<script language="javascript">
<?php include("./Includes/ControleDate.js");  //ControleDate(d) : Contrle du format JJ-MM-AAAA de la date d
   include("./Includes/AddDelai.js");      //AddDelai(d,D)   : Retourne une date au format JJ-MM-AAAA en ajoutant un dlai D (nombre de jours)  une date d au format JJ-MM-AAAA
?>
/* ---------------------------------------------------------------------------------------- */
/* Contrle des valeurs des champs du formulaire                                            */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(form) {
 if (!ControleDate(form.DateDeb.value)) {
  alert("La date de dbut d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  form.DateDeb.focus();
  return false;
 }
 if (!ControleDate(form.DateFin.value)) {
  alert("La date de fin d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  form.DateFin.focus();
  return false;
 }
 return true
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE DEBUT D'AFFICHAGE                                               */
/* ---------------------------------------------------------------------------------------- */
function DateDeb_Change(DateDeb) {
 if (!ControleDate(DateDeb.value)) {
  alert("La date de dbut d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateDeb.focus();
  return;
 }
}
function DateDeb_Moins_Click(DateDeb) {
 if (!ControleDate(DateDeb.value)) {
  alert("La date de dbut d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateDeb.focus();
  return;
 }
 DateDeb.value=AddDelai(DateDeb.value,-1);
}
function DateDeb_Plus_Click(DateDeb) {
 if (!ControleDate(DateDeb.value)) {
  alert("La date de dbut d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateDeb.focus();
  return;
 }
 DateDeb.value=AddDelai(DateDeb.value,1);
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE FIN D'AFFICHAGE                                                 */
/* ---------------------------------------------------------------------------------------- */
function DateFin_Change(DateFin) {
 if (!ControleDate(DateFin.value)) {
  alert("La date de fin d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateFin.focus();
  return;
 }
}
function DateFin_Moins_Click(DateFin) {
 if (!ControleDate(DateFin.value)) {
  alert("La date de fin d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateFin.focus();
  return;
 }
 DateFin.value=AddDelai(DateFin.value,-1);
}
function DateFin_Plus_Click(DateFin) {
 if (!ControleDate(DateFin.value)) {
  alert("La date de fin d\'affichage est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateFin.focus();
  return;
 }
 DateFin.value=AddDelai(DateFin.value,1);
}
</script>
</HEAD>
<BODY onLoad="top.document.title='<?php echo AddSlashes($titre); ?>';window.defaultStatus='Analyse des transactions par postes budgtaires'">
<!-- Dbut du formulaire ---------------------------------------------------------------------->
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" onSubmit="return control_saisie(this)">
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>Transactions passes entre le </td>
  <td class=tdleft>
   <BUTTON TYPE="BUTTON" name="DateDeb_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de dbut d\'affichage'"
    onClick="DateDeb_Moins_Click(DateDeb)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="DateDeb" SIZE="10" maxlength="10" value="<?php echo $DateDeb; ?>"
    onMouseOver="javascript:window.status='Date de dbut d\'affichage'"
    onChange="javascript:DateDeb_Change(DateDeb)">&nbsp;
   <BUTTON TYPE="BUTTON" name="DateDeb_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de dbut d\'affichage'"
    onClick="javascript:DateDeb_Plus_Click(DateDeb)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td>
  <td class=tdleft> et le </td>
  <td class=tdleft>
   <BUTTON TYPE="BUTTON" name="DateFin_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de fin d\'affichage'"
    onClick="javascript:DateFin_Moins_Click(DateFin)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="DateFin" SIZE="10" maxlength="10" value="<?php echo $DateFin; ?>"
    onMouseOver="javascript:window.status='Date de fin d\'affichage'"
    onChange="javascript:DateFin_Change(DateFin)">&nbsp;
   <BUTTON TYPE="BUTTON" name="DateFin_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de fin d\'affichage'"
    onClick="javascript:DateFin_Plus_Click(DateFin)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td>
  <td class=tdleft>
   <button type="submit" name="Recalculer_button">Recalculer</button></td>
 </tr>
</table>
</form>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" onSubmit="return false">
<table>
 <tr>
  <td class=tdleft>
   <a href="Help/AnalyseBudgetaire_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>
<hr size=2 width="100%"> <!------------------------------------------------------->

<?php // Constitution des tables $recDepense, $recRecette, $statDepense et $statRecette
$bgcolor="";$i=0;$IdNature_save="";$TotalDepense=0;$TotalRecette=0;
unset($AnalysePostes);$recDepense=Array();$recRecette=Array();unset($statDepense);unset($statRecette);
if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE; 
if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE; 
while($rsMouvement_OK and $rsMouvementArch_OK) {
 if ($MouvementArch['NumOrd']==$Mouvement['NumOrd'] and $MouvementArch['IdNature']==$Mouvement['IdNature']) {
  if ($Mouvement['IdNature']!=$IdNature_save) {
   $sql="SELECT LibNature FROM Rubrique WHERE IdNature='".$Mouvement['IdNature']."'";
   $rsNature=send_sql($dblk, $sql);$Nature=mysqli_fetch_array($rsNature,MYSQLI_ASSOC);$IdNature_save=$Mouvement['IdNature'];
  }
  $Solde=$Mouvement['TotalRecette']+$MouvementArch['TotalRecette']-$Mouvement['TotalDepense']-$MouvementArch['TotalDepense'];
  if ($Solde<0) {
    $recDepense[$i++]=array ( "IdNature"=>$Mouvement['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>-$Solde,"Pourcentage"=>0 );
    $statDepense[$Nature['LibNature']]=-$Solde;
    $TotalDepense=$TotalDepense-$Solde;}
  else {
    $recRecette[$i++]=array ( "IdNature"=>$Mouvement['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>$Solde,"Pourcentage"=>0 );
    $statRecette[$Nature['LibNature']]=$Solde;
    $TotalRecette=$TotalRecette+$Solde;}
  if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE; 
  if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE; 
 }
 else {
  if ($MouvementArch['NumOrd']<$Mouvement['NumOrd'] or ($MouvementArch['NumOrd']==$Mouvement['NumOrd'] and $MouvementArch['IdNature']<$Mouvement['IdNature'])) {
   if ($MouvementArch['IdNature']!=$IdNature_save) {
    $sql="SELECT LibNature FROM Rubrique WHERE IdNature='".$MouvementArch['IdNature']."'";
    $rsNature=send_sql($dblk, $sql);$Nature=mysqli_fetch_array($rsNature,MYSQLI_ASSOC);$IdNature_save=$MouvementArch['IdNature'];
   }
   $Solde=$MouvementArch['TotalRecette']-$MouvementArch['TotalDepense'];
   if ($Solde<0) {
    $recDepense[$i++]=array ( "IdNature"=>$MouvementArch['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>-$Solde,"Pourcentage"=>0 );
    $statDepense[$Nature['LibNature']]=-$Solde;
    $TotalDepense=$TotalDepense-$Solde;}
   else {
    $recRecette[$i++]=array ( "IdNature"=>$MouvementArch['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>$Solde,"Pourcentage"=>0 );
    $statRecette[$Nature['LibNature']]=$Solde;
    $TotalRecette=$TotalRecette+$Solde;}
   if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE; 
  }
  else {
   if ($Mouvement['IdNature']!=$IdNature_save) {
    $sql="SELECT LibNature FROM Rubrique WHERE IdNature='".$Mouvement['IdNature']."'";
    $rsNature=send_sql($dblk, $sql);$Nature=mysqli_fetch_array($rsNature,MYSQLI_ASSOC);$IdNature_save=$Mouvement['IdNature'];
   }
   $Solde=$Mouvement['TotalRecette']-$Mouvement['TotalDepense'];
   if ($Solde<0) {
    $recDepense[$i++]=array ( "IdNature"=>$Mouvement['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>-$Solde,"Pourcentage"=>0 );
    $statDepense[$Nature['LibNature']]=-$Solde;
    $TotalDepense=$TotalDepense-$Solde;}
   else {
    $recRecette[$i++]=array ( "IdNature"=>$Mouvement['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>$Solde,"Pourcentage"=>0 );
    $statRecette[$Nature['LibNature']]=$Solde;
    $TotalRecette=$TotalRecette+$Solde;}
   if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE; 
  }
 }
}
while($rsMouvement_OK) {
 if ($Mouvement['IdNature']!=$IdNature_save) {
  $sql="SELECT LibNature FROM Rubrique WHERE IdNature='".$Mouvement['IdNature']."'";
  $rsNature=send_sql($dblk, $sql);$Nature=mysqli_fetch_array($rsNature,MYSQLI_ASSOC);$IdNature_save=$Mouvement['IdNature'];
 }
 $Solde=$Mouvement['TotalRecette']-$Mouvement['TotalDepense'];
 if ($Solde<0) {
  $recDepense[$i++]=array ( "IdNature"=>$Mouvement['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>-$Solde,"Pourcentage"=>0 );
  $statDepense[$Nature['LibNature']]=-$Solde;
  $TotalDepense=$TotalDepense-$Solde;}
 else {
  $recRecette[$i++]=array ( "IdNature"=>$Mouvement['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>$Solde,"Pourcentage"=>0 );
  $statRecette[$Nature['LibNature']]=$Solde;
  $TotalRecette=$TotalRecette+$Solde;}
 if ($Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC)) $rsMouvement_OK=TRUE; else $rsMouvement_OK=FALSE; 
}
while($rsMouvementArch_OK) {
 if ($MouvementArch['IdNature']!=$IdNature_save) {
  $sql="SELECT LibNature FROM Rubrique WHERE IdNature='".$MouvementArch['IdNature']."'";
  $rsNature=send_sql($dblk, $sql);$Nature=mysqli_fetch_array($rsNature,MYSQLI_ASSOC);$IdNature_save=$MouvementArch['IdNature'];
 }
 $Solde=$MouvementArch['TotalRecette']-$MouvementArch['TotalDepense'];
 if ($Solde<0) {
  $recDepense[$i++]=array ( "IdNature"=>$MouvementArch['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>-$Solde,"Pourcentage"=>0 );
  $statDepense[$Nature['LibNature']]=-$Solde;
  $TotalDepense=$TotalDepense-$Solde;}
 else {
  $recRecette[$i++]=array ( "IdNature"=>$MouvementArch['IdNature'],"LibNature"=>$Nature['LibNature'],"Montant"=>$Solde,"Pourcentage"=>0 );
  $statRecette[$Nature['LibNature']]=$Solde;
  $TotalRecette=$TotalRecette+$Solde;}
 if ($MouvementArch=mysqli_fetch_array($rsMouvementArch,MYSQLI_ASSOC)) $rsMouvementArch_OK=TRUE; else $rsMouvementArch_OK=FALSE;
}
$TotSansImputation=$TotMouvementArch['Recette']-$TotMouvementArch['Depense']+$TotMouvement['Recette']-$TotMouvement['Depense']-$TotalRecette+$TotalDepense;
if (abs($TotSansImputation)>1) {
 if ($TotSansImputation>0) {
  $recRecette[$i++]=array ( "IdNature"=>'NORUBR',"LibNature"=>"Sans imputation","Montant"=>$TotSansImputation,"Pourcentage"=>0 );
  $statRecette['Sans imputation']=$TotSansImputation;
  $TotalRecette=$TotalRecette+$TotSansImputation;}
 if ($TotSansImputation<0) {
  $recDepense[$i++]=array ( "IdNature"=>'NORUBR',"LibNature"=>"Sans imputation","Montant"=>-$TotSansImputation,"Pourcentage"=>0 );
  $statDepense['Sans imputation']=-$TotSansImputation;
  $TotalDepense=$TotalDepense-$TotSansImputation;}
}

if (count($recDepense)<count($recRecette)) {
 for ($i=count($recDepense);$i<count($recRecette);$i++)
  $recDepense[]=array ( "IdNature"=>"","LibNature"=>"","Montant"=>"","Pourcentage"=>"" );
} else {
 for ($i=count($recRecette);$i<count($recDepense);$i++)
  $recRecette[]=array ( "IdNature"=>"","LibNature"=>"","Montant"=>"","Pourcentage"=>"" );
}
if (count($recDepense)>0) $AffDepense=reset($recDepense);
if (count($recRecette)>0) $AffRecette=reset($recRecette);
$i=0;

if (extension_loaded("gd")){
 $Path="Graphiques/";$Folder=dir($Path);
 while ($Fichier=$Folder->read()) {
  if (substr($Fichier,0,14)=="RepartRecettes") unlink($Path.$Fichier);
  if (substr($Fichier,0,14)=="RepartDepenses") unlink($Path.$Fichier);
 }
 $Folder->close();
 if (isset($statRecette)) {
  $fileRepartRecettes="Graphiques/RepartRecettes_".microtime().".png";
  Draw_Secteurs($statRecette,550,350,10,"Rpartition des recettes",true,$fileRepartRecettes);
 }
 if (isset($statDepense)) {
  $fileRepartDepenses="Graphiques/RepartDepenses_".microtime().".png";
  Draw_Secteurs($statDepense,550,350,10,"Rpartition des dpenses",true,$fileRepartDepenses);
 }
} ?>

<table border=0 cellspacing=1 cellpadding=0>
 <tr>
  <th class=thcenter><?php
if (extension_loaded("gd") and isset($statRecette)){
 $fileRepartRecettes_mini="Graphiques/RepartRecettes_mini_".microtime().".png";
 if (Draw_Secteurs($statRecette,20,20,1,"",false,$fileRepartRecettes_mini)) { ?>
  <input type="image" src="<?php echo $fileRepartRecettes_mini; ?>" onClick="Graphique.src='<?php echo $fileRepartRecettes; ?>'"><?php
 }
} else echo "&nbsp;"; ?></th>
  <th class=thcenter>Recettes</th>
  <th class=thcenter><?php echo number_format($TotalRecette,'0','.',' ')," ",$DeviseRefer['Format']; ?></th>
  <th>&nbsp;</th>
  <th class=thcenter><?php
if (extension_loaded("gd") and isset($statDepense)) {
 $fileRepartDepenses_mini="Graphiques/RepartDepenses_mini_".microtime().".png";
 if (Draw_Secteurs($statDepense,20,20,1,"",false,$fileRepartDepenses_mini)) { ?>
  <input type="image" src="<?php echo $fileRepartDepenses_mini; ?>" onClick="Graphique.src='<?php echo $fileRepartDepenses; ?>'"><?php
 }
} else echo "&nbsp;"; ?></th>
  <th class=thcenter>Dpenses</th>
  <th class=thcenter><?php echo number_format($TotalDepense,'0','.',' ')," ",$DeviseRefer['Format']; ?></th>
 </tr>
 <tr><td>&nbsp;</td></tr><?php
for ($j=0;$j<count($recDepense);$j++) { 
 $bgcolor == "#99CCFF" ? $bgcolor="#CCFFFF" : $bgcolor="#99CCFF"; ?>
 <tr ><?php
  if ($AffRecette['LibNature']=="" and $AffRecette['Montant']==0) { ?>
   <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><?php }
  else { ?>
   <td class=tdcenter bgcolor="<?php echo $bgcolor; ?>">
    <?php if ($AffRecette['IdNature']<>'NORUBR') { ?>
          <a href="AnalysePoste.php?PosAnaPos=<?php echo $i; ?>" title="Accs au dtail du poste"
           onMouseOver="document.images.puce_<?php echo $i; ?>.src='<?php echo $Pointrouge; ?>'"
           onMouseOut="document.images.puce_<?php echo $i; ?>.src='<?php echo $Pointbleu; ?>'">
          <img id="puce_<?php echo $i; ?>" border=0 width=12 height=12 src="<?php echo $Pointbleu; ?>" name="puce_<?php echo $i; ?>" alt="Pointbleu"></a></td><?php
       } ?>
   <td class=tdleft bgcolor="<?php echo $bgcolor; ?>"><?php echo $AffRecette['LibNature']; ?></td>
   <td class=tdright bgcolor="<?php echo $bgcolor; ?>"><?php echo number_format($AffRecette['Montant'],'0','.',' ')." ".$DeviseRefer['Format']; ?></td>
    <?php $AnalysePostes[$i++]=$AffRecette['IdNature'];} ?>
   <td class=tdleft>&nbsp;</td><?php
  if ($AffDepense['LibNature']=="" and $AffDepense['Montant']==0) { ?>
   <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><?php }
  else { ?>
   <td class=tdcenter bgcolor="<?php echo $bgcolor; ?>">
    <?php if ($AffDepense['IdNature']<>'NORUBR') { ?>
          <a href="AnalysePoste.php?PosAnaPos=<?php echo $i; ?>" title="Accs au dtail du poste"
          onMouseOver="document.images.puce_<?php echo $i; ?>.src='<?php echo $Pointrouge; ?>'"
          onMouseOut="document.images.puce_<?php echo $i; ?>.src='<?php echo $Pointbleu; ?>'">
          <img id="puce_<?php echo $i; ?>" border=0 width=12 height=12 src="<?php echo $Pointbleu; ?>" name="puce_<?php echo $i; ?>" alt="Poinbleu"></a></td><?php
       } ?>
   <td class=tdleft bgcolor="<?php echo $bgcolor; ?>"><?php echo $AffDepense['LibNature']; ?></td>
   <td class=tdright bgcolor="<?php echo $bgcolor; ?>"><?php echo number_format($AffDepense['Montant'],'0','.',' ')." ".$DeviseRefer['Format']; ?></td>
    <?php $AnalysePostes[$i++]=$AffDepense['IdNature'];} ?>
 </tr><?php
  $AffRecette=next($recRecette);$AffDepense=next($recDepense);
} ?>
 <tr><td class=tdleft>&nbsp;</td></tr>
 <tr><th class=thcenter colspan="7">
  <?php if ($TotalRecette>=$TotalDepense) echo "Capacit d'pargne : ",number_format(($TotalRecette-$TotalDepense),'0','.',' ')," ",$DeviseRefer['Format'];
     else echo "Endettement : ",number_format(($TotalDepense-$TotalRecette),'0','.',' ')," ",$DeviseRefer['Format']; ?></th>
 </tr>
</table><br>
<img name="Graphique" src="<?php echo $Vide; ?>" alt="graphique">
<?php if (!isset($AnalysePostes)) { $AnalysePostes=Array();echo "<p>Aucune rubrique budgtaire impute entre les dates spcifies</p>"; }
   $_SESSION['AnalysePostes']=$AnalysePostes; ?>
</form>
</BODY>
</HTML>
