<?php
/* ===================================================================================== */
/* Bilan.php : Prsentation du bilan financier                                           */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML et remplacement des flches gauche et droite     */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de la reprsentation graphique sous forme de secteurs            */
/* Version   : 1.2           Date : 12-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.3           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Dtection de la bibliothque GD des fonctions graphiques               */
/* Version   : 1.4           Date : 02-02-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.5           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.5";

$titre="Bilan financier";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
include("./Includes/Draw_Secteurs.php");   //illustration de statistiques sous forme de secteurs
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);          //Connexion et Slection de la base de donnes
/* ---------------------------------------------------------------------------------------- */
/* Rcupration de la devise de rfrence :$DeviseRefer                                     */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdDevise,Format,Taux FROM Devise WHERE Reference='O'";
  $rsDeviseRefer=send_sql($dblk, $sql);
  if (!$DeviseRefer=mysqli_fetch_array($rsDeviseRefer,MYSQLI_ASSOC)) { ?>
   <h1>Devise de rfrence non dfinie</h1>
   <P>La constitution du bilan gnral ncessite la conversion des soldes des diffrents comptes dans une devise identique.<br>
      Il convient de dfinir cette devise de rfrence dans la gestion des 
      <a href="Devises.php">Devises</a>. 
   </p>
   <?php exit; }
/* ---------------------------------------------------------------------------------------- */
/* Initialisation des soldes de postes du bilan                                             */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT BilanPoste.IdPoste,Sens FROM BilanPoste,BilanRubrique Where BilanPoste.IdRubrique=BilanRubrique.IdRubrique";
  $rsBilanPostes=send_sql($dblk, $sql);
  while($BilanPostes=mysqli_fetch_array($rsBilanPostes,MYSQLI_ASSOC)) {
   $sql="SELECT SoldReel,IdDevise,UsCpt FROM Compte ";
   $sql=$sql."WHERE IdPoste='".$BilanPostes['IdPoste']."' ORDER BY IdDevise";
   $rsBilanComptes=send_sql($dblk, $sql);$IdDevise_save="";unset($BilanComptes);$SoldePoste=0;
   while($BilanComptes=mysqli_fetch_array($rsBilanComptes,MYSQLI_ASSOC)) {
    if ($BilanComptes['IdDevise']!=$IdDevise_save) {
     $sql="SELECT Taux FROM Devise WHERE IdDevise='".$BilanComptes['IdDevise']."'";
     $rsDeviseCompte=send_sql($dblk, $sql);$DeviseCompte=mysqli_fetch_array($rsDeviseCompte,MYSQLI_ASSOC);
     $IdDevise_save=$BilanComptes['IdDevise'];
    }
    $SoldeCompte=Round($BilanComptes['SoldReel']/$DeviseCompte['Taux']*$DeviseRefer['Taux']);
    if ($BilanComptes['UsCpt']=="P") $SoldeCompte=-$SoldeCompte;
    $SoldePoste=$SoldePoste+$SoldeCompte;
   }
   if ($BilanPostes['Sens']=="P") $SoldePoste = - $SoldePoste;
   $sql="UPDATE BilanPoste SET Solde=".$SoldePoste." WHERE IdPoste='".$BilanPostes['IdPoste']."'";
   send_sql($dblk, $sql);
  }
/* ---------------------------------------------------------------------------------------- */
/* Initialisation des soldes de rubriques du bilan : $Rubriques                             */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT BilanRubrique.IdRubrique,SUM(BilanPoste.Solde) AS SoldeRubrique FROM BilanRubrique,BilanPoste ";
  $sql=$sql."WHERE BilanRubrique.IdRubrique=BilanPoste.IdRubrique GROUP BY BilanRubrique.IdRubrique";
  $rsSoldes=send_sql($dblk, $sql);$i=0;$Rubriques=Array();
  while($Soldes=mysqli_fetch_array($rsSoldes,MYSQLI_ASSOC)) {
   $Rubriques[$i++]=array ( "IdRubrique"=>$Soldes['IdRubrique'],"Solde"=>$Soldes['SoldeRubrique'] );
  }
/* ---------------------------------------------------------------------------------------- */
/* Initialisation des soldes Actif et Passif du bilan                                       */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Sens,SUM(BilanPoste.Solde) AS SoldeSens FROM BilanRubrique,BilanPoste ";
  $sql=$sql."WHERE BilanRubrique.IdRubrique=BilanPoste.IdRubrique GROUP BY Sens";
  $rsSoldes=send_sql($dblk, $sql);$i=0;$SoldeActif=0;$SoldePassif=0;
  while($Soldes=mysqli_fetch_array($rsSoldes,MYSQLI_ASSOC)) {
   if ($Soldes['Sens']=="A") $SoldeActif=$Soldes['SoldeSens'];
   else  $SoldePassif=$Soldes['SoldeSens'];
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubriques et postes au passif du bilan : $AffBilanPassifs               */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT BilanRubrique.IdRubrique,LibRubrique,IdPoste,LibPoste,Solde ";
  $sql=$sql."FROM BilanRubrique LEFT JOIN BilanPoste ";
  $sql=$sql."ON BilanRubrique.IdRubrique=BilanPoste.IdRubrique ";
  $sql=$sql."WHERE Sens='P' ORDER BY BilanRubrique.NumOrd,BilanPoste.NumOrd";
  $rsBilanPassifs=send_sql($dblk, $sql);
  $i=0;$AffBilanPassif=Array();unset($StatBilanPassif);$IdRubrique_save="";

  while($BilanPassif=mysqli_fetch_array($rsBilanPassifs,MYSQLI_ASSOC)) {
   if ($BilanPassif['IdRubrique']!=$IdRubrique_save) {
    $AffBilanPassif[$i++]=array ( "IdRubrique"=>"","LibRubrique"=>"",
     "IdPoste"=>"","LibPoste"=>"","Solde"=>"" ); $IdRubrique_save=$BilanPassif['IdRubrique'];
    $SoldeRubrique=0; //par dfaut. Sinon le rcuprer dans la table $Rubriques
    if (count($Rubriques)>0) {
     foreach ($Rubriques as $Rubrique) {
      if ($Rubrique['IdRubrique']==$BilanPassif['IdRubrique']) {
       $SoldeRubrique=$Rubrique['Solde'];
       break;
      }
     }
    }
    $AffBilanPassif[$i++]=array ( "IdRubrique"=>$BilanPassif['IdRubrique'],"LibRubrique"=>$BilanPassif['LibRubrique'],
     "IdPoste"=>"","LibPoste"=>"","Solde"=>$SoldeRubrique ); $IdRubrique_save=$BilanPassif['IdRubrique'];
   }
   if ($BilanPassif['IdPoste']!="") {
    $AffBilanPassif[$i++]=array ( "IdRubrique"=>$BilanPassif['IdRubrique'],"LibRubrique"=>$BilanPassif['LibRubrique'],
     "IdPoste"=>$BilanPassif['IdPoste'],"LibPoste"=>$BilanPassif['LibPoste'],"Solde"=>$BilanPassif['Solde'] );
    $StatBilanPassif[$BilanPassif['LibPoste']]=$BilanPassif['Solde'];
   }
  }

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubriques et postes  l'actif du bilan : $AffBilanActifs                */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT BilanRubrique.IdRubrique,LibRubrique,IdPoste,LibPoste,Solde ";
  $sql=$sql."FROM BilanRubrique LEFT JOIN BilanPoste ";
  $sql=$sql."ON BilanRubrique.IdRubrique=BilanPoste.IdRubrique ";
  $sql=$sql." WHERE Sens='A' ORDER BY BilanRubrique.NumOrd,BilanPoste.NumOrd";
  $rsBilanActifs=send_sql($dblk, $sql);
  $i=0;$AffBilanActif=Array();unset($StatBilanActif);$IdRubrique_save="";
  while($BilanActif=mysqli_fetch_array($rsBilanActifs,MYSQLI_ASSOC)) {
   if ($BilanActif['IdRubrique']!=$IdRubrique_save) {
    $AffBilanActif[$i++]=array ( "IdRubrique"=>"","LibRubrique"=>"",
     "IdPoste"=>"","LibPoste"=>"","Solde"=>"" ); $IdRubrique_save=$BilanActif['IdRubrique'];
    $SoldeRubrique=0; //par dfaut. Sinon le rcuprer dans la table $Rubriques
    if (count($Rubriques)>0) {
     foreach ($Rubriques as $Rubrique) {
      if ($Rubrique['IdRubrique']==$BilanActif['IdRubrique']) {
       $SoldeRubrique=$Rubrique['Solde'];
       break;
      }
     }
    }
    $AffBilanActif[$i++]=array ( "IdRubrique"=>$BilanActif['IdRubrique'],"LibRubrique"=>$BilanActif['LibRubrique'],
     "IdPoste"=>"","LibPoste"=>"","Solde"=>$SoldeRubrique ); $IdRubrique_save=$BilanActif['IdRubrique'];
   }
   if ($BilanActif['IdPoste']!="") {
    $AffBilanActif[$i++]=array ( "IdRubrique"=>$BilanActif['IdRubrique'],"LibRubrique"=>$BilanActif['LibRubrique'],
     "IdPoste"=>$BilanActif['IdPoste'],"LibPoste"=>$BilanActif['LibPoste'],"Solde"=>$BilanActif['Solde'] );
    $StatBilanActif[$BilanActif['LibPoste']]=$BilanActif['Solde'];
   }
  }

if (extension_loaded("gd")){
 $Path="Graphiques/";
 $Folder=dir($Path);
 while ($Fichier=$Folder->read()) {
  if (substr($Fichier,0,12)=="RepartPassif") unlink($Path.$Fichier);
  if (substr($Fichier,0,11)=="RepartActif") unlink($Path.$Fichier);
 }
 $Folder->close();
 if (isset($StatBilanPassif)) {
  $fileRepartPassif="Graphiques/RepartPassif_".microtime().".png";
  Draw_Secteurs($StatBilanPassif,550,350,10,"Rpartition du passif",true,$fileRepartPassif);
 }
 if (isset($StatBilanActif)) {
  $fileRepartActif="Graphiques/RepartActif_".microtime().".png";
  Draw_Secteurs($StatBilanActif,550,350,10,"Rpartition des actifs",true,$fileRepartActif);
 }
}
?> 
<HTML>
<HEAD>
<TITLE>Bilan gnral</TITLE>
<META name="description" content="Prsentation du bilan gnral">
<META name="keywords" content="">
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">
<script language="javascript">
</script>
</HEAD>
<BODY onLoad="top.document.title='<?php echo AddSlashes($titre); ?>';window.defaultStatus=top.document.title">
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>
   <a href="BilanRubrique.php?PosBilRub=N" title="Crer une rubrique du bilan gnral">Nouvelle rubrique</a></td>
  <td class=tdleft>
   <a href="Help/BilanGeneral_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>
<hr size=2 width="100%"> <!------------------------------------------------------->
<!-- Dbut du formulaire ---------------------------------------------------------------------->
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" onSubmit="return false">
<table border=0 cellspacing=1 cellpadding=0>
 <tr>
  <th class=thcenter><?php
if (isset($StatBilanPassif)) {
 if (extension_loaded("gd")){
  $fileRepartPassif_mini="Graphiques/RepartPassif_mini_".microtime().".png";
  if (Draw_Secteurs($StatBilanPassif,20,20,1,"",false,$fileRepartPassif_mini)) { ?>
   <input type="image" src="<?php echo $fileRepartPassif_mini; ?>" onClick="Graphique.src='<?php echo $fileRepartPassif; ?>'"><?php
  } else echo "&nbsp;";
 } else echo "&nbsp;";
} else echo "&nbsp;"; ?></th>
  <th class=thcenter>Passif</th>
  <th class=thcenter><?php echo number_format($SoldePassif,'0','.',' ')," ",$DeviseRefer['Format'] ?></th>
  <th>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
  <th class=thcenter><?php
if (isset($StatBilanActif)) {
 if (extension_loaded("gd")){
  $fileRepartActif_mini="Graphiques/RepartActif_mini_".microtime().".png";
  if (Draw_Secteurs($StatBilanActif,20,20,1,"",false,$fileRepartActif_mini)) { ?>
   <input type="image" src="<?php echo $fileRepartActif_mini; ?>" onClick="Graphique.src='<?php echo $fileRepartActif; ?>'"><?php
  } else echo "&nbsp;";
 } else echo "&nbsp;";
} else echo "&nbsp;"; ?></th>
  <th class=thcenter>Actif</th>
  <th class=thcenter><?php echo number_format($SoldeActif,'0','.',' ')," ",$DeviseRefer['Format'] ?></th>
 </tr>
<?php
$Rubriquebgcolor="#99CCFF";$Postebgcolor="#CCFFFF";unset($BilanRubriques);$j=0;
if (count($AffBilanPassif)<count($AffBilanActif)) {
 for ($i=count($AffBilanPassif);$i<count($AffBilanActif);$i++)
  $AffBilanPassif[$i]=array ( "IdRubrique"=>"","LibRubrique"=>"","IdPoste"=>"","LibPoste"=>"","Solde"=>"" );
} else {
 for ($i=count($AffBilanActif);$i<count($AffBilanPassif);$i++)
  $AffBilanActif[$i]=array ( "IdRubrique"=>"","LibRubrique"=>"","IdPoste"=>"","LibPoste"=>"","Solde"=>"" );
}
$BilanPassifPoste=reset($AffBilanPassif);$BilanActifPoste=reset($AffBilanActif);
for ($i=0;$i<count($AffBilanActif);$i++) {
 echo "<tr>";
 if ($BilanPassifPoste['IdRubrique']=="") {
  echo "<td>&nbsp</td>";
  echo "<td>&nbsp</td>";
  echo "<td>&nbsp</td>"; }
 else {
  if ($BilanPassifPoste['IdPoste']=="") { ?>
   <td class=tdcenter bgcolor="<?php echo $Rubriquebgcolor; ?>"><a href="BilanRubrique.php?PosBilRub=<?php echo $j; ?>"
       title="Accs aux caractristiques de la rubrique"
       onMouseOver="document.images.puce_P<?php echo $i; ?>.src='<?php echo $Pointrouge; ?>'"
       onMouseOut="document.images.puce_P<?php echo $i; ?>.src='<?php echo $Pointbleu; ?>'">
       <img id="puce_P<?php echo $i; ?>" border=0 width=12 height=12 src="<?php echo $Pointbleu; ?>" name="puce_P<?php echo $i; ?>" alt="Poinbleu"></a></td>
   <td class=tdleft bgcolor="<?php echo $Rubriquebgcolor; ?>"><b><?php echo $BilanPassifPoste['LibRubrique']; ?></b></td>
   <td class=tdright bgcolor="<?php echo $Rubriquebgcolor; ?>"><b><?php echo number_format($BilanPassifPoste['Solde'],'0','.',' ')." ".$DeviseRefer['Format']; ?></b></td><?php
   $BilanRubriques[$j++]=$BilanPassifPoste['IdRubrique'];
  }
  else { ?>
   <td class=tdleft style="padding-left:15pt" bgcolor="<?php echo $Postebgcolor; ?>"></td>
   <td class=tdleft style="padding-left:15pt" bgcolor="<?php echo $Postebgcolor; ?>"><?php echo $BilanPassifPoste['LibPoste']; ?></td>
   <td class=tdright bgcolor="<?php echo $Postebgcolor; ?>"><?php echo number_format($BilanPassifPoste['Solde'],'0','.',' ')." ".$DeviseRefer['Format']; ?></td><?php
  }
 }
 echo "<td>&nbsp</td>";
 if ($BilanActifPoste['IdRubrique']=="") {
  echo "<td>&nbsp</td>";
  echo "<td>&nbsp</td>"; }
 else {
  if ($BilanActifPoste['IdPoste']=="") { ?>
   <td class=tdcenter bgcolor="<?php echo $Rubriquebgcolor; ?>"><a href="BilanRubrique.php?PosBilRub=<?php echo $j; ?>"
       title="Accs aux caractristiques de la rubrique"
       onMouseOver="document.images.puce_A<?php echo $i; ?>.src='<?php echo $Pointrouge; ?>'"
       onMouseOut="document.images.puce_A<?php echo $i; ?>.src='<?php echo $Pointbleu; ?>'">
       <img id="puce_A<?php echo $i; ?>" border=0 width=12 height=12 src="<?php echo $Pointbleu; ?>" name="puce_A<?php echo $i; ?>" alt="Pointbleu"></a></td>
   <td class=tdleft bgcolor="<?php echo $Rubriquebgcolor; ?>"><b><?php echo $BilanActifPoste['LibRubrique']; ?></b></td>
   <td class=tdright bgcolor="<?php echo $Rubriquebgcolor; ?>"><b><?php echo number_format($BilanActifPoste['Solde'],'0','.',' ')." ".$DeviseRefer['Format']; ?></b></td><?php
   $BilanRubriques[$j++]=$BilanActifPoste['IdRubrique'];
  }
  else { ?>
   <td class=tdleft style="padding-left:15pt" bgcolor="<?php echo $Postebgcolor; ?>"></td>
   <td class=tdleft style="padding-left:15pt" bgcolor="<?php echo $Postebgcolor; ?>"><?php echo $BilanActifPoste['LibPoste']; ?></td>
   <td class=tdright bgcolor="<?php echo $Postebgcolor; ?>"><?php echo number_format($BilanActifPoste['Solde'],'0','.',' ')." ".$DeviseRefer['Format']; ?></td><?php
  }
 }
 echo "</tr>";
 $BilanPassifPoste=next($AffBilanPassif);$BilanActifPoste=next($AffBilanActif);
} ?>
 <tr><td>&nbsp</td><tr>
  <th class=thcenter colspan="7"><?php
   if ($SoldeActif>=$SoldePassif) echo "Actif Net : ",number_format(($SoldeActif-$SoldePassif),'0','.',' ');
   else echo "Passif Net : ",number_format(($SoldePassif-$SoldeActif),'0','.',' ');
   echo " ",$DeviseRefer['Format']; ?></th>
 </tr>
</table><br>
<img name="Graphique" src="<?php echo $Vide; ?>" alt="Graphique">
<?php if (mysqli_num_rows($rsBilanActifs)+mysqli_num_rows($rsBilanPassifs)==0) echo "<p>Aucune rubrique enregistre pour le bilan</p>";
   if (!isset($BilanRubriques)) $BilanRubriques=Array();
   $_SESSION['BilanRubriques']=$BilanRubriques;
?>
</form> <!-- Fin du formulaire ------------------------------------------------------------------->
</BODY>
</HTML>

