<?php
/* ===================================================================================== */
/* Compte.php : Caractristiques d'un compte courant ou d'pargne                        */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML et remplacement des flches gauche et droite     */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de ; aprs &nbsp dans <p class=msg>&nbsp...                      */
/* Version   : 1.2           Date : 15-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Interdiction de ne saisir que des espaces comme identifiant ...        */
/*                Abandon du contrle de la saisie si bouton Annuler                     */
/*                Abandon du contrle du nombre de dpendances pour les nouveaux comptes */
/* Version   : 1.3           Date : 15-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.4           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.5           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.5";

$titre="Caractristiques du compte";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);          //Connexion et Slection de la base de donnes
include("./Includes/Compte_save.php");     //Mise  jour du compte, s'il y a lieu

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des proprits du compte : $Compte                                          */
/* ---------------------------------------------------------------------------------------- */
  $nbDependance=0;$nbReleve=0; //Si cration de compte, pas d'objet dpendant, ni de relev de compte
  if ($PosCpt!=="N") {
   $sql="SELECT IdCpt,IntCpt,NumOrd,NumCpt,IdEtab,IdDevise,SoldInit,Actif,UsCpt,Comment FROM Compte WHERE IdCpt='".$_SESSION['Comptes'][$PosCpt]."'";
   $rsCompte=send_sql($dblk, $sql);$Compte=mysqli_fetch_array($rsCompte,MYSQLI_ASSOC);
/* ---------------------------------------------------------------------------------------- */
/* Dtermination du nombre de dpendances pour autoriser le changement de devise ou d'usage */
/* et l'existence d'un relev de compte pour interdire la modification du solde initial     */
/* ---------------------------------------------------------------------------------------- */
   $sql="SELECT COUNT(*) as NbRec FROM CompteReleve WHERE IdCpt='".$_SESSION['Comptes'][$PosCpt]."'";
   $res=send_sql($dblk, $sql);$record=mysqli_fetch_array($res,MYSQLI_ASSOC);$nbReleve=$record['NbRec'];
   if ($record['NbRec']==0) {
    $sql="SELECT COUNT(*) as NbRec FROM Mouvement WHERE IdCpt='".$_SESSION['Comptes'][$PosCpt]."'";
    $res=send_sql($dblk, $sql);$record=mysqli_fetch_array($res,MYSQLI_ASSOC);
    if ($record['NbRec']==0) {
     $sql="SELECT COUNT(*) as NbRec FROM CompteOpeCour WHERE IdCpt='".$_SESSION['Comptes'][$PosCpt]."'";
     $res=send_sql($dblk, $sql);$record=mysqli_fetch_array($res,MYSQLI_ASSOC);
     if ($record['NbRec']==0) {
      $sql="SELECT COUNT(*) as NbRec FROM Echeance WHERE IdCpt='".$_SESSION['Comptes'][$PosCpt]."'";
      $res=send_sql($dblk, $sql);$record=mysqli_fetch_array($res,MYSQLI_ASSOC);
     }
    }
   }
   $nbDependance=$record['NbRec'];
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des tablissements pour liste droulante : $rsEtablissements                */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdEtab,LibEtab FROM Etablissement WHERE Actif='O' ORDER BY LibEtab";
  $rsEtablissements=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des devises pour liste droulante : $rsDevises                              */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdDevise,LibDevise FROM Devise ORDER BY LibDevise";
  $rsDevises=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Prparation de l'affichage des champs du formulaire                                      */
/* ---------------------------------------------------------------------------------------- */
if (isset($Msg)) {               // champs en readonly si compte existant
 if ($PosCpt!=="N") {
  $valeur_init['IdDevise']=$Compte['IdDevise'];
  $valeur_init['UsCpt']=$Compte['UsCpt'];
 }
} else {
 if ($PosCpt==="N") {
  $valeur_init['IdCpt']="";$valeur_init['IntCpt']="";$valeur_init['NumCpt']="";$valeur_init['NumOrd']="";
  $valeur_init['IdEtab']="";$valeur_init['Actif']="";$valeur_init['IdDevise']="";$valeur_init['SoldInit']="";
  $valeur_init['UsCpt']=$selUsCpt;$Comment="";
 } else {
  $valeur_init['IdCpt']=$Compte['IdCpt'];
  $valeur_init['IntCpt']=$Compte['IntCpt'];
  $valeur_init['NumCpt']=$Compte['NumCpt'];
  $valeur_init['NumOrd']=$Compte['NumOrd'];
  $valeur_init['IdEtab']=$Compte['IdEtab'];
  $valeur_init['Actif']=$Compte['Actif'];
  $valeur_init['IdDevise']=$Compte['IdDevise'];
  $valeur_init['SoldInit']=$Compte['SoldInit'];
  $valeur_init['UsCpt']=$Compte['UsCpt'];
  $Comment=$Compte['Comment'];
 }
}
$Status=($PosCpt==="N") ? AddSlashes($titre." (nouveau compte)") : AddSlashes($titre." (".($PosCpt+1)." sur ".count($_SESSION['Comptes']).")"); //defaultStatus
?>

<HTML>
<HEAD>
<TITLE>Caractristiques d'un compte</TITLE>
<META name="description" content="Description d'un compte">
<META name="keywords" content=""> 
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">
<script language="javascript">
/* ---------------------------------------------------------------------------------------- */
/* Contrle des valeurs des champs du formulaire                                            */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(Mode,IdCpt,IntCpt,NumOrd,IdDevise,SoldInit,UsCpt) {
 if (Mode.value=="A") return true;
 if (Mode.value=="S") {
  if (UsCpt[0].checked) reponse=window.confirm("Confirmez-vous la suppression de ce compte ?");
  else reponse=window.confirm("La suppression du compte supprimera galement les chances.\nConfirmez-vous la suppression de ce compte ?");
  return reponse;
 }
 if (IdCpt.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le code identifiant le compte est une information  saisir obligatoirement")
  IdCpt.focus();
  return false
 } 
 if ((IdCpt.value.indexOf('\'')!=-1) || (IdCpt.value.indexOf('\\')!=-1) || (IdCpt.value.indexOf('%')!=-1)) {
  alert("Le code du compte contient un caractre spcial interdit, une apostrophe, un \\ ou un % peut-tre.")
  IdCpt.focus()
  return false
 }
 if (IntCpt.value.replace(RegExp(" ","g"),"")=="") {
  alert("L'intitul du compte est une information  saisir obligatoirement")
  IntCpt.focus();
  return false
 }
 if (isNaN(NumOrd.value)) {
  alert("Le numro d'ordre du compte doit tre une information numrique")
  NumOrd.focus();
  return false
 }
 if (IdDevise.value=="") {
  alert("La devise de gestion du compte est une information  slectionner obligatoirement")
  IdDevise.focus();
  return false
 }
 if (SoldInit.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le solde initial du compte est une information  saisir obligatoirement")
  SoldInit.focus();
  return false
 }
 if (isNaN(SoldInit.value)) {
  alert("Le solde initial du compte doit tre une information numrique")
  SoldInit.focus();
  return false
 }
 if (!UsCpt[0].checked && !UsCpt[1].checked) {
  alert("Slectionner obligatoirement une des options pour l'usage du compte") 
  UsCpt[0].focus();
  return false
 }
 if (NumOrd.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le numro d'ordre du compte est une information  saisir obligatoirement")
  NumOrd.focus();
  return false
 }
 return true
}
</script>
</HEAD>
<BODY onLoad="top.document.title='Compte';window.defaultStatus='<?php echo $Status; ?>'">
<table border=0 cellspacing=0 cellpadding=0> <!----- Directives d'entte ----->
 <tr>
  <td class=tdleft>
   <?php if ($PosCpt>0 and $PosCpt!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosCpt=<?php echo ($PosCpt-1); ?>&selUsCpt=<?php echo $Compte['UsCpt']; ?>" title="Accder au compte prcdent">Prcdent</a><?php
      } else echo "Prcdent"; ?></td>
  <td class=tdleft>
   <?php if ($PosCpt<count($_SESSION['Comptes'])-1 and $PosCpt!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosCpt=<?php echo ($PosCpt+1); ?>&selUsCpt=<?php echo $Compte['UsCpt']; ?>" title="Accder au compte suivant">Suivant</a><?php
      } else echo "Suivant"; ?></td>
  <td class=tdleft>
   <?php if ($PosCpt!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosCpt=N&selUsCpt=<?php echo $Compte['UsCpt']; ?>" title="Crer un compte">Nouveau</a><?php
      } else echo "Nouveau"; ?></td>
  <td class=tdleft><?php if (isset($Compte)) $selUsCpt=$Compte['UsCpt']; ?>
      <a href="Comptes.php?selUsCpt=<?php echo $selUsCpt; ?>" title="Retour  la liste des comptes">Retour</a></td>
  <td class=tdleft>
   <a href="Help/Compte_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>                                                   <!-- Fin de directives d'entte -->
<hr size=2 width="100%"><!----------------------------------------------------------->

<!------------------------------------- Dbut de formulaire --------------------------------->
<form action="Compte.php" method="post" onSubmit="return control_saisie(Mode,IdCpt,IntCpt,NumOrd,IdDevise,SoldInit,UsCpt)">
<input type="hidden" name="selUsCpt" value="<?php echo $selUsCpt; ?>"> <!-- Transmission  Compte_save.php -->
<input type="hidden" name="PosCpt" value="<?php echo $PosCpt; ?>"> <!-- Transmission  Compte_save.php -->
<input type="hidden" name="Mode" value=""> <!-- = "S" si bouton Supprimer activ, "A" si Annuler  -->
<table border=0 cellspacing=0 cellpadding=0> <!------------ Zones de saisie ----------------->
 <tr>
  <td class=tdleft>Code du compte</td>
  <td class=tdleft>
   <INPUT TYPE=TEXT name="IdCpt" SIZE="5" maxlength="5" value="<?php echo $valeur_init['IdCpt']; ?>" <?php if ($PosCpt!=="N") echo "readonly"; ?>
    onMouseOver="javascript:window.status='Code interne obligatoire pour identifier le compte'"></td></tr>
 <tr>
  <td class=tdleft>Intitul</td>
  <td class=tdleft>
    <input TYPE=TEXT name="IntCpt" SIZE="50" maxlength="50" value="<?php echo $valeur_init['IntCpt']; ?>"
    onMouseOver="javascript:window.status='Intitul du compte obligatoire'"></td></tr>
 <tr>
  <td class=tdleft>Numro de compte</td>
  <td class=tdleft> 
   <INPUT TYPE=TEXT name="NumCpt" SIZE="23" maxlength="23" value="<?php echo $valeur_init['NumCpt']; ?>"
    onMouseOver="javascript:window.status='Numro de compte (Relev d\'Identit Bancaire), facultatif'"></td></tr>
 <tr>
  <td class=tdleft>Etablissement dtenteur</td>
  <td class=tdleft> 
   <select name="IdEtab"
    onMouseOver="javascript:window.status='Etablissement financier dtenteur du compte, facultatif'">
	<option value="">non dtermin</option><?php
     while($record=mysqli_fetch_array($rsEtablissements,MYSQLI_ASSOC)) {
      ($valeur_init['IdEtab']==$record['IdEtab']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $record['IdEtab']; ?>" <?php echo $selected; ?>><?php echo $record['LibEtab']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Monnaie du compte</td>
  <td class=tdleft> 
   <select name="IdDevise" <?php if ($nbDependance>0) echo "disabled"; ?>
    onMouseOver="javascript:window.status='Unit montaire de rfrence du compte, obligatoire'">
	<option value="">non dtermin</option><?php
     while($record=mysqli_fetch_array($rsDevises,MYSQLI_ASSOC)) {
          ($valeur_init['IdDevise']==$record['IdDevise']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $record['IdDevise']; ?>" <?php echo $selected; ?>><?php echo $record['LibDevise']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Solde initial</td>
  <td class=tdleft> 
   <INPUT TYPE=TEXT name="SoldInit" SIZE="17" maxlength="17" style="text-align:right" value="<?php echo $valeur_init['SoldInit']; ?>" <?php if ($nbReleve>0) echo "readonly"; ?>
    onMouseOver="javascript:window.status='Solde initial du compte'"></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Usage du compte</td>
  <td class=tdleft>
   <input type="radio" name="UsCpt" value="A" <?php if ($valeur_init['UsCpt']=="A") echo "checked"; ?> <?php if ($nbDependance>0) echo "disabled"; ?>  
    onMouseOver="javascript:window.status='Slectionner cette option pour un compte  usage classique'">
    Courant, pargne ou crdit</td></tr>
 <tr>
  <td>&nbsp</td>
  <td class=tdleft>
   <input type="radio" name="UsCpt" value="P" <?php if ($valeur_init['UsCpt']=="P") echo "checked"; ?> <?php if ($nbDependance>0) echo "disabled"; ?>
    onMouseOver="javascript:window.status='Slectionner cette option pour un compte  usage d\'emprunt'">
    Emprunt  remboursement programm</td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Numro d'ordre</td>
  <td class=tdleft> 
   <INPUT TYPE=TEXT name="NumOrd" SIZE="6" maxlength="6" style="text-align:right" value="<?php echo $valeur_init['NumOrd']; ?>"
    onMouseOver="javascript:window.status='Rang d\'affichage du compte, obligatoire'"></td></tr>
 <tr>
  <td class=tdleft>Compte oprationnel</td>
  <td class=tdleft>
   <INPUT TYPE="CHECKBOX" name="Actif" <?php if ($valeur_init['Actif']=="O") echo "checked"; ?>
    onMouseOver="javascript:window.status='Cocher la case pour que le compte apparaisse dans les listes de slection'"></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Commentaires</td>
  <td class=tdleft>
   <TEXTAREA name="Comment" ROWS="3" COLS="40"
    onMouseOver="javascript:window.status='Texte libre facultatif'"><?php echo $Comment; ?></TEXTAREA></td></tr>
</table>                   <!------------------ Fin de zone de saisie ------------------->
<hr size=2 width="100%"><!----------------------------------------------------------->

<table border=0 cellspacing=0 cellpadding=0> <!------------ liens vers rubriques et modes de paiement ----------------->
 <tr>
  <td class=tdleft><?php
    if ($PosCpt!=="N") {
     if ($Compte['UsCpt']=="A") echo "<a href=\"Compte_Rubriques.php?PosCpt=$PosCpt\" title=\"Accder aux rubriques usuelles du compte\">Rubriques usuelles</a>";
     else {
      $sql="SELECT COUNT(*) as NbRec FROM Emprunt WHERE IdCpt='".$_SESSION['Comptes'][$PosCpt]."'";
      $res=send_sql($dblk, $sql);$record=mysqli_fetch_array($res,MYSQLI_ASSOC);
      if ($record['NbRec']>0)  echo "<a href=\"Compte_Emprunt.php?PosCpt=$PosCpt\" title=\"Accder aux conditions de l'emprunt\">Conditions de l'emprunt</a>";
     }
    } ?></td>
  <td class=tdleft>
   <?php if ($PosCpt!=="N" and $Compte['UsCpt']=="A") echo "<a href=\"Compte_ModesReglement.php?PosCpt=$PosCpt\" title=\"Accder aux modes de rglement autoriss du compte\">Modes de rglement autoriss</a>"; ?></td></tr>
</table>
<table border=0 cellspacing=0 cellpadding=0 width="100%"> <!---------- Boutons de commande ----------> 
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class="tdbutton"><input type="submit" value="Enregistrer" onClick="Mode.value='V'"
    onMouseOver="javascript:window.status='Sauvegarde des caractristiques du compte'"></td>
  <td class="tdbutton"><button type="submit" name="Annuler" onClick="Mode.value='A'"
    onMouseOver="javascript:window.status='Annulation des modifications du compte'">Annuler</button></td>
  <td class="tdbutton"><button type="submit" name="Supprimer" <?php if ($PosCpt==="N") echo "disabled"; ?> onClick="Mode.value='S'"
    onMouseOver="javascript:window.status='Demande de suppression du compte'">Supprimer</button></td>
  <td class="tdbutton" width="100%"></td>
 </tr>
</table> <!-------------- Fin des boutons de commande ------------------>
<?php if (isset($Msg)) { ?>
 <p class=msg>&nbsp;<?php echo $Msg; ?></p>
<?php } ?>
</form>  <!-------------- Fin de formulaire           ------------------>
</body>
</html>
