<?php
/* ===================================================================================== */
/* EcheancierRemboursement.php : Echancier de remboursement d'une simulation d'emprunt  */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction pow(a,b) par exp(log(a)*b) pour            */
/*                compatibilit avec les versions ultrieures  la 4.0.6 de PHP          */
/* Version   : 1.1           Date : 27-01-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML et remplacement des flches gauche et droite     */
/* Version   : 1.2           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.3           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.4           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.4";

$titre="Simulation de remboursement d'emprunt";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);          //Connexion et Slection de la base de donnes

$PosSimEmp=$_REQUEST['PosSimEmp'];

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des proprits de la simulation : $SimulEmprunt                             */
/* ---------------------------------------------------------------------------------------- */
$sql="SELECT NumOrd,MntEmprunt,TauxIntAnn,TauxAssAnn,PerRbt,NbPer,MntRbtPer,MntAssPer,PremEch ";
$sql=$sql."FROM SimulEmprunt WHERE NumOrd='".$_SESSION['SimulsEmprunt'][$PosSimEmp]."'";
$rsSimulEmprunt=send_sql($dblk, $sql);$SimulEmprunt=mysqli_fetch_array($rsSimulEmprunt,MYSQLI_ASSOC);
if ($SimulEmprunt['PremEch']=="0000-00-00") $SimulEmprunt['PremEch']="";
$x=1+($SimulEmprunt['TauxIntAnn']+$SimulEmprunt['TauxAssAnn'])/$SimulEmprunt['PerRbt']/100;
$MntRbtPer=$SimulEmprunt['MntEmprunt']/(1-1/exp(log($x)*$SimulEmprunt['NbPer']))*($x-1);
//$MntRbtPer=$SimulEmprunt['MntEmprunt']/(1-1/pow($x,$SimulEmprunt['NbPer']))*($x-1);
//$MntRbtPer=$SimulEmprunt['MntRbtPer'];
$SimulEmprunt['MntRbtTotal']=$SimulEmprunt['NbPer']*($SimulEmprunt['MntRbtPer']+$SimulEmprunt['MntAssPer']);
$SimulEmprunt['MntCout']=$SimulEmprunt['MntRbtTotal']-$SimulEmprunt['MntEmprunt'];
$SimulEmprunt['TauxRbtEmprunt']=$SimulEmprunt['MntRbtTotal']*100/$SimulEmprunt['MntEmprunt'];
/* ---------------------------------------------------------------------------------------- */
/* Constitution de l'chancier                                                             */
/* ---------------------------------------------------------------------------------------- */
$MntCapRest=$SimulEmprunt['MntEmprunt'];$DateEch=$SimulEmprunt['PremEch'];
for ($i=0;$i<$SimulEmprunt['NbPer']-1;$i++) {
 $MntRbtAss=round($MntCapRest*$SimulEmprunt['TauxAssAnn']/$SimulEmprunt['PerRbt'])/100;
 $MntRbtInt=round($MntCapRest*$SimulEmprunt['TauxIntAnn']/$SimulEmprunt['PerRbt'])/100;
 $MntRbtCap=round($MntRbtPer*100-$MntCapRest*($SimulEmprunt['TauxIntAnn']+$SimulEmprunt['TauxAssAnn'])/$SimulEmprunt['PerRbt'])/100;
 $MntRbtPerTot=$SimulEmprunt['MntRbtPer']+$SimulEmprunt['MntAssPer'];
 $MntCapRest=$MntCapRest-$MntRbtCap;
 $Ech[$i] = array (
  "Ord"=>$i+1,
  "DateEch"=>$DateEch,
  "MntRbtCap"=>$MntRbtCap,
  "MntRbtInt"=>$MntRbtInt,
  "MntRbtAss"=>$MntRbtAss,
  "MntRbtFrAdm"=>$SimulEmprunt['MntAssPer'],
  "MntRbtPerTot"=>$MntRbtPerTot,
  "MntCapRest"=>$MntCapRest );
 if ($DateEch!="") {
  switch ($SimulEmprunt['PerRbt']) {
   case 12:$DateEch=date("Y-m-d",mktime(0,0,0,substr($DateEch,5,2)+1,substr($DateEch,8,2),substr($DateEch,0,4)));break;
   case 4 :$DateEch=date("Y-m-d",mktime(0,0,0,substr($DateEch,5,2)+3,substr($DateEch,8,2),substr($DateEch,0,4)));break;
   case 2 :$DateEch=date("Y-m-d",mktime(0,0,0,substr($DateEch,5,2)+6,substr($DateEch,8,2),substr($DateEch,0,4)));break;
   case 1 :$DateEch=date("Y-m-d",mktime(0,0,0,substr($DateEch,5,2),substr($DateEch,8,2),substr($DateEch,0,4)+1));break;
   default:
  }
 }
}
$MntRbtAss=round($MntCapRest*$SimulEmprunt['TauxAssAnn']/$SimulEmprunt['PerRbt'])/100;
$MntRbtCap=round($MntCapRest*100)/100;
$MntRbtInt=round(($MntRbtPer-$MntRbtCap-$MntRbtAss)*100)/100;
$MntRbtPerTot=$SimulEmprunt['MntRbtPer']+$SimulEmprunt['MntAssPer'];
$MntCapRest=0;
$Ech[$i] = array (
 "Ord"=>$SimulEmprunt['NbPer'],
 "DateEch"=>$DateEch,
 "MntRbtCap"=>$MntRbtCap,
 "MntRbtInt"=>$MntRbtInt,
 "MntRbtAss"=>$MntRbtAss,
 "MntRbtFrAdm"=>$SimulEmprunt['MntAssPer'],
 "MntRbtPerTot"=>$MntRbtPerTot,
 "MntCapRest"=>$MntCapRest );
?> 
<HTML>
<HEAD>
<TITLE>Echancier de remboursement</TITLE>
<META name="description" content="Echancier de remboursement">
<META name="keywords" content="">
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">
<script language="javascript">

</script>
</HEAD>
<BODY onLoad="top.document.title='<?php echo AddSlashes($titre); ?>';window.defaultStatus=top.document.title">
<table border=0 cellspacing=0 cellpadding=0> <!----- Directives d'entte ----->
 <tr>
  <td class=tdleft>
   <?php if ($PosSimEmp>0) { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosSimEmp=<?php echo ($PosSimEmp-1); ?>" title="Accder  l'chancier de la simulation prcdente">Prcdent</a><?php
      } else echo "Prcdent"; ?></td>
  <td class=tdleft>
   <?php if ($PosSimEmp<count($_SESSION['SimulsEmprunt'])-1) { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosSimEmp=<?php echo ($PosSimEmp+1); ?>" title="Accder  l'chancier de la simulation suivante">Suivant</a><?php
      } else echo "Suivant"; ?></td>
  <td class=tdleft>
   <a href="SimulEmprunt.php?PosSimEmp=<?php echo $PosSimEmp; ?>" title="Retour aux caractristiques de la simulation">Retour</a></td>
  <td class=tdleft>
   <a href="Help/SimulationEmprunt_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>                                                   <!-- Fin de directives d'entte -->
<hr size=2 width="100%"><!----------------------------------------------------------->

<!-- Dbut du formulaire ---------------------------------------------------------------------->
<form id="saisie" action="EcheancierRemboursement.php" method="post">
<input type="hidden" name="PosSimEmp" value="<?php echo $PosSimEmp; ?>"> <!-- Transmission  SimulEmprunt_save.php -->
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <th class=thcenter>Code</th>
  <th class=thcenter>Montant</th>
  <th class=thcenter>Taux</th>
  <th class=thcenter>Frais</th>
  <th class=thcenter>Priod.</th>
  <th class=thcenter>Nombre</th>
  <th class=thcenter>Rembt</th>
  <th class=thcenter>Frais</th>
  <th class=thcenter>Rembt</th>
  <th class=thcenter>Cot de</th>
  <th class=thcenter>Rembt/</th></tr>
 <tr>
  <th class=thcenter>&nbsp</th>
  <th class=thcenter>Emprunt</th>
  <th class=thcenter>d'ntrt</th>
  <th class=thcenter>Gestion</th>
  <th class=thcenter>Rembt</th>
  <th class=thcenter>Rembt</th>
  <th class=thcenter>priod.</th>
  <th class=thcenter>admin.</th>
  <th class=thcenter>total</th>
  <th class=thcenter>l'emprunt</th>
  <th class=thcenter>Emprunt</th></tr>
 <tr><?php
 foreach($SimulEmprunt as $fld=>$field) {
  switch ($fld) {
   case "MntEmprunt"    :echo "<td class=tdright>",number_format($field,'2','.',' '),"</td>";break;
   case "TauxIntAnn"    :echo "<td class=tdright>",number_format($field,'3','.',' '),"%</td>";break;
   case "TauxAssAnn"    :echo "<td class=tdright>",number_format($field,'3','.',' '),"%</td>";break;
   case "NbPer"         :echo "<td class=tdright>",number_format($field,'0','.',' '),"</td>";break;
   case "MntRbtPer"     :echo "<td class=tdright>",number_format($field,'2','.',' '),"</td>";break;
   case "MntAssPer"     :echo "<td class=tdright>",number_format($field,'2','.',' '),"</td>";break;
   case "MntRbtTotal"   :echo "<td class=tdright>",number_format($field,'2','.',' '),"</td>";break;
   case "MntCout"       :echo "<td class=tdright>",number_format($field,'2','.',' '),"</td>";break;
   case "TauxRbtEmprunt":echo "<td class=tdright>",number_format($field,'0','.',' ')," %</td>";break;
   case "PerRbt" :
    switch ($field) {
     case 12 : $Periode="mois";break;
     case 4  : $Periode="trimestre";break;
     case 2  : $Periode="semestre";break;
     case 1  : $Periode="anne";break;
     default :
    }
    echo "<td class=tdcenter>",$Periode,"</td>";break;
   case "PremEch":break;
   default :echo "<td class=tdleft>",$field,"</td>";
  }
 } ?></tr>
</table>
<table border=0 cellspacing=1 cellpadding=0> <!------------ Tableau d'affichage --------->
 <tr><td>&nbsp</td></tr>
 <tr>
  <th class=thcenter>N</th>
  <?php if ($SimulEmprunt['PremEch']!="") echo "<th class=thcenter>Date</th>"; ?>
  <th class=thcenter>Capital</th>
  <th class=thcenter>Intrt</th>
  <th class=thcenter>Assur.</th>
  <th class=thcenter>Frais</th>
  <th class=thcenter>Total</th>
  <th class=thcenter>Restant</th>
 </tr>
<?php $bgcolor="";
foreach($Ech as $rec=>$record) {
 $bgcolor == "#99CCFF" ? $bgcolor="#CCFFFF" : $bgcolor="#99CCFF"; ?>
 <tr bgcolor="<?php echo $bgcolor; ?>"><?php
  foreach($record as $fld=>$field) {
   switch ($fld) {
    case "Ord"        :echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",$field,"</td>\n";break;
    case "MntRbtInt"  :echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",number_format($field,'2','.',' '),"</td>\n";break;
    case "MntRbtAss"  :echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",number_format($field,'2','.',' '),"</td>\n";break;
    case "MntRbtCap"  :echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",number_format($field,'2','.',' '),"</td>\n";break;
    case "MntRbtFrAdm":echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",number_format($field,'2','.',' '),"</td>\n";break;
    case "MntRbtFrAdm":echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",number_format($field,'2','.',' '),"</td>\n";break;
    case "MntCapRest" :echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",number_format($field,'2','.',' '),"</td>\n";break;
    case "DateEch"    :if ($SimulEmprunt['PremEch']!="") echo "<td class=tdright style=\"padding-left:10pt;padding-right:10pt\">",invDate($field,"-","JMAA"),"</td>\n";break;
    default :echo "<td class=tdleft style=\"padding-left:10pt;padding-right:10pt\">",$field,"</td>\n";
   }
  }
 echo "</tr>\n";
 } ?>
</table>
</form>  <!-------------- Fin de formulaire           ------------------>
</body>
</html>
