/* ======================================================================================== */
/* ControleDate.js : Contrle de format date JJ-MM-AAAA d'une chane de caractres d        */
/*                   la fonction retourne un objet date en cas de format correct            */
/*                   ou le boolen false sinon                                              */
/* Version   : 1.0           Date : 05-07-2002        Auteur : Jean-Louis BATAILLE          */
/* ======================================================================================== */
/* ControleDate.js : Contrle de la longueur de la date pour interdire les dates du genre   */
/*                   01-01-200 ou infrieures au 01-01-1970                                 */
/* Version   : 1.1           Date : 15-01-2003        Auteur : Jean-Louis BATAILLE          */
/* ======================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.2           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
function ControleDate(date_string) {
 if (date_string.length!=10) return false;
 var tab_date=date_string.split("-");          //constitue le tableau tab_date compos du jour, du mois et de l'anne
 obj_date=new Date(tab_date[2],tab_date[1]-1,tab_date[0]); //constitue l'objet date  partir des lments du tableau
 if (parseInt(tab_date[2])<1970) return false;
 return  (obj_date.getDate()==tab_date[0] && 
         obj_date.getMonth()+1==tab_date[1] &&
         obj_date.getFullYear()==tab_date[2]) ? obj_date : false;
}
