<?php
/* ===================================================================================== */
/* Create_DataBase.php : Cration de la base de donnes                                  */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Correction de la casse des noms de table Chequier,                     */
/*                CompteOpeCourRubrique et CompteReleveMouvementRubrique                 */
/* Version   : 1.1           Date : 14-12-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.2           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.3           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */

#
# Structure de la table `bilanposte`
#
$sql="CREATE TABLE BilanPoste (
  IdPoste varchar(4) NOT NULL default '',
  LibPoste varchar(30) NOT NULL default '',
  NumOrd smallint(6) NOT NULL default '0',
  IdRubrique varchar(4) NOT NULL default '',
  Solde decimal(14,2) default NULL,
  PRIMARY KEY  (IdPoste)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg="La cration de la base ".$db." a chou sur la table BilanPoste.<br>";
#
# Structure de la table `bilanrubrique`
#
$sql="CREATE TABLE BilanRubrique (
  IdRubrique varchar(4) NOT NULL default '',
  LibRubrique varchar(30) NOT NULL default '',
  Sens char(1) NOT NULL default '',
  NumOrd smallint(6) NOT NULL default '0',
  PRIMARY KEY  (IdRubrique)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table BilanRubrique.<br>";
#
# Structure de la table `chequier`
#
$sql="CREATE TABLE Chequier (
  IdChequier smallint(6) unsigned NOT NULL default '0',
  IdCpt varchar(5) NOT NULL default '',
  UtilChq varchar(5) default NULL,
  StatChq char(1) NOT NULL default '',
  PremChq mediumint(9) unsigned NOT NULL default '0',
  DernChq mediumint(9) unsigned NOT NULL default '0',
  ProchChq mediumint(9) unsigned NOT NULL default '0',
  ActChq char(1) NOT NULL default '',
  Comment text,
  PRIMARY KEY  (IdChequier,IdCpt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Chequier.<br>";
#
# Structure de la table `compte`
#
$sql="CREATE TABLE Compte (
  IdCpt varchar(5) NOT NULL default '',
  IdEtab varchar(5) default NULL,
  NumOrd smallint(6) default NULL,
  NumCpt varchar(23) default NULL,
  IntCpt varchar(50) NOT NULL default '',
  SoldInit decimal(14,2) NOT NULL default '0.00',
  SoldReel decimal(14,2) NOT NULL default '0.00',
  Actif char(1) NOT NULL default '',
  Comment text,
  IdDevise varchar(6) NOT NULL default '',
  UsCpt char(1) NOT NULL default '',
  IdPoste varchar(4) NOT NULL default '',
  PRIMARY KEY  (IdCpt),
  KEY NumOrd (NumOrd)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Compte.<br>";
#
# Structure de la table `comptemoderegl`
#
$sql="CREATE TABLE CompteModeRegl (
  IdCpt varchar(5) NOT NULL default '',
  IdModRegl varchar(4) NOT NULL default '',
  ActDepense char(1) NOT NULL default '',
  ActRecette char(1) NOT NULL default '',
  PRIMARY KEY  (IdCpt,IdModRegl)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteModeRegl.<br>";
#
# Structure de la table `compteopecour`
#
$sql="CREATE TABLE CompteOpeCour (
  IdCpt varchar(5) NOT NULL default '',
  LibMvt varchar(30) NOT NULL default '',
  SensMvt char(1) NOT NULL default '',
  ModMvt varchar(4) NOT NULL default '',
  TypMvt char(1) NOT NULL default '',
  MntMvt decimal(14,2) default '0.00',
  MotMvt text,
  NatMvt varchar(6) default NULL,
  IdLibMvt varchar(6) NOT NULL default '',
  LgPer smallint(6) default NULL,
  UnitPer char(1) default NULL,
  ProchEch date default NULL,
  DernEch date default NULL,
  OpePer char(1) NOT NULL default '',
  Actif char(1) NOT NULL default '',
  PRIMARY KEY  (IdLibMvt,IdCpt),
  KEY LibMvt (LibMvt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteOpeCour.<br>";
#
# Structure de la table `CompteOpeCourRubrique`
#
$sql="CREATE TABLE CompteOpeCourRubrique (
  IdCpt varchar(5) NOT NULL default '',
  IdLibMvt varchar(6) NOT NULL default '',
  IdNature varchar(6) NOT NULL default '',
  MntImp decimal(14,2) NOT NULL default '0.00',
  PRIMARY KEY  (IdCpt,IdLibMvt,IdNature)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteOpeCourRubrique.<br>";
#
# Structure de la table `comptereleve`
#
$sql="CREATE TABLE CompteReleve (
  IdCpt varchar(5) NOT NULL default '',
  IdRel mediumint(9) NOT NULL default '0',
  NumRel varchar(10) NOT NULL default '',
  DateRelPrec date NOT NULL default '0000-00-00',
  SoldRelPrec decimal(14,2) NOT NULL default '0.00',
  DateRel date NOT NULL default '0000-00-00',
  SoldRel decimal(14,2) NOT NULL default '0.00',
  Comment text,
  PRIMARY KEY  (IdCpt,IdRel)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteReleve.<br>";
#
# Structure de la table `compterelevemouvement`
#
$sql="CREATE TABLE CompteReleveMouvement (
  IdMvt bigint(20) NOT NULL default '0',
  IdCpt varchar(5) NOT NULL default '',
  IdRel mediumint(9) NOT NULL default '0',
  DateMvt date NOT NULL default '0000-00-00',
  LibMvt varchar(30) NOT NULL default '',
  ModMvt varchar(4) NOT NULL default '',
  TypMvt char(1) NOT NULL default '',
  SensMvt char(1) NOT NULL default '',
  MntMvt decimal(14,2) NOT NULL default '0.00',
  DateVal date NOT NULL default '0000-00-00',
  MotMvt text,
  IdChequier smallint(6) unsigned default NULL,
  IdChq mediumint(9) unsigned default NULL,
  PRIMARY KEY  (IdMvt),
  KEY IdCpt (IdCpt,IdRel,DateMvt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteReleveMouvement.<br>";
#
# Structure de la table `CompteReleveMouvementRubrique`
#
$sql="CREATE TABLE CompteReleveMouvementRubrique (
  IdMvt bigint(20) NOT NULL default '0',
  IdNature varchar(6) NOT NULL default '',
  MntImp decimal(14,2) NOT NULL default '0.00',
  PRIMARY KEY  (IdMvt,IdNature)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteReleveMouvementRubrique.<br>";
#
# Structure de la table `compterubrique`
#
$sql="CREATE TABLE CompteRubrique (
  IdCpt varchar(5) NOT NULL default '',
  IdNature varchar(6) NOT NULL default '',
  ActDepense char(1) NOT NULL default '',
  ActRecette char(1) NOT NULL default '',
  PRIMARY KEY  (IdCpt,IdNature)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table CompteRubrique.<br>";
#
# Structure de la table `devise`
#
$sql="CREATE TABLE Devise (
  IdDevise varchar(6) NOT NULL default '',
  LibDevise varchar(30) NOT NULL default '',
  Format varchar(4) default NULL,
  Taux decimal(7,5) NOT NULL default '0.00000',
  Reference char(1) default NULL,
  PRIMARY KEY  (IdDevise)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Devise.<br>";
#
# Structure de la table `echeance`
#
$sql="CREATE TABLE Echeance (
  MajSolde char(1) NOT NULL default '',
  IdMvt bigint(20) NOT NULL default '0',
  IdCpt varchar(5) NOT NULL default '',
  DateMvt date NOT NULL default '0000-00-00',
  SensMvt char(1) NOT NULL default '',
  MntRbtCap decimal(14,2) NOT NULL default '0.00',
  MotMvt text,
  MntRbtInt decimal(14,2) NOT NULL default '0.00',
  MntRbtAss decimal(14,2) NOT NULL default '0.00',
  MntCapRest decimal(14,2) NOT NULL default '0.00',
  MntRbtFr decimal(14,2) NOT NULL default '0.00',
  PRIMARY KEY  (IdMvt),
  KEY IdCpt (IdCpt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Echeance.<br>";
#
# Structure de la table `emprunt`
#
$sql="CREATE TABLE Emprunt (
  IdCpt varchar(5) NOT NULL default '',
  MntEmprunt decimal(14,2) NOT NULL default '0.00',
  TauxIntAnn decimal(7,5) NOT NULL default '0.00000',
  TauxAssAnn decimal(7,5) NOT NULL default '0.00000',
  PerRbt tinyint(4) NOT NULL default '0',
  NbPer smallint(6) NOT NULL default '0',
  MntRbtPer decimal(14,2) NOT NULL default '0.00',
  MntAssPer decimal(14,2) NOT NULL default '0.00',
  PremEch date default NULL,
  PRIMARY KEY  (IdCpt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Emprunt.<br>";
#
# Structure de la table `etablissement`
#
$sql="CREATE TABLE Etablissement (
  IdEtab varchar(5) binary NOT NULL default '',
  LibEtab varchar(50) binary NOT NULL default '',
  Actif char(1) NOT NULL default 'O',
  Comment text,
  PRIMARY KEY  (IdEtab)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Etablissement.<br>";
#
# Structure de la table `modereglement`
#
$sql="CREATE TABLE ModeReglement (
  IdModRegl varchar(4) NOT NULL default '',
  LibModRegl varchar(50) NOT NULL default '',
  TypRegl char(1) NOT NULL default '',
  IdentRegl char(1) NOT NULL default '',
  PRIMARY KEY  (IdModRegl)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table ModeReglement.<br>";
#
# Structure de la table `modereglementcondition`
#
$sql="CREATE TABLE ModeReglementCondition (
  IdModRegl varchar(4) NOT NULL default '',
  JourDebut tinyint(2) NOT NULL default '0',
  JourFin tinyint(2) NOT NULL default '0',
  DelaiRegl smallint(4) NOT NULL default '0',
  JourRegl tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (IdModRegl,JourDebut)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table ModeReglementCondition.<br>";
#
# Structure de la table `mouvement`
#
$sql="CREATE TABLE Mouvement (
  MajSolde char(1) NOT NULL default '',
  IdMvt bigint(20) NOT NULL default '0',
  IdCpt varchar(5) NOT NULL default '',
  DateMvt date NOT NULL default '0000-00-00',
  LibMvt varchar(30) NOT NULL default '',
  ModMvt varchar(4) NOT NULL default '',
  TypMvt char(1) NOT NULL default '',
  SensMvt char(1) NOT NULL default '',
  MntMvt decimal(14,2) NOT NULL default '0.00',
  DateVal date NOT NULL default '0000-00-00',
  MotMvt text,
  NatMvt varchar(6) default NULL,
  IdChequier smallint(6) unsigned default NULL,
  IdChq mediumint(9) unsigned default NULL,
  Pointe tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (IdMvt),
  KEY IdCpt (IdCpt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Mouvement.<br>";
#
# Structure de la table `mouvementrubrique`
#
$sql="CREATE TABLE MouvementRubrique (
  IdMvt bigint(20) NOT NULL default '0',
  IdNature varchar(6) NOT NULL default '',
  MntImp decimal(14,2) NOT NULL default '0.00',
  PRIMARY KEY  (IdMvt,IdNature)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table MouvementRubrique.<br>";
#
# Structure de la table `opeprog`
#
$sql="CREATE TABLE OpeProg (
  IdCpt varchar(5) NOT NULL default '',
  LibMvt varchar(30) NOT NULL default '',
  SensMvt char(1) NOT NULL default '',
  ModMvt varchar(4) NOT NULL default '',
  TypMvt char(1) NOT NULL default '',
  MntMvt decimal(14,2) default '0.00',
  MotMvt text,
  NatMvt varchar(6) default NULL,
  DateMvt date default NULL,
  DateVal date default NULL,
  MajSolde char(1) NOT NULL default '',
  IdMvt bigint(20) NOT NULL default '0',
  ProchEch date default NULL,
  IdLibMvt varchar(6) NOT NULL default '',
  PRIMARY KEY  (IdMvt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table OpeProg.<br>";
#
# Structure de la table `opeprogrubrique`
#
$sql="CREATE TABLE OpeProgRubrique (
  IdMvt bigint(20) NOT NULL default '0',
  IdNature varchar(6) NOT NULL default '',
  MntImp decimal(14,2) NOT NULL default '0.00',
  PRIMARY KEY  (IdMvt,IdNature)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table OpeProgRubrique.<br>";
#
# Structure de la table `rubrique`
#
$sql="CREATE TABLE Rubrique (
  IdNature varchar(6) NOT NULL default '',
  LibNature varchar(50) NOT NULL default '',
  Comment text,
  NumOrd smallint(6) NOT NULL default '0',
  PRIMARY KEY  (IdNature)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table Rubrique.<br>";
#
# Structure de la table `simulemprunt`
#
$sql="CREATE TABLE SimulEmprunt (
  NumOrd varchar(6) NOT NULL default '',
  MntEmprunt decimal(14,2) NOT NULL default '0.00',
  TauxIntAnn decimal(7,5) NOT NULL default '0.00000',
  TauxAssAnn decimal(7,5) NOT NULL default '0.00000',
  PerRbt tinyint(4) NOT NULL default '0',
  NbPer smallint(6) NOT NULL default '0',
  MntRbtPer decimal(14,2) NOT NULL default '0.00',
  MntAssPer decimal(14,2) NOT NULL default '0.00',
  Comment text,
  PremEch date default NULL,
  PRIMARY KEY  (NumOrd)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table SimulEmprunt.<br>";
#
# Structure de la table `typemouvement`
#
$sql="CREATE TABLE TypeMouvement (
  IdTypMvt char(1) NOT NULL default '',
  LibTypMvt varchar(50) NOT NULL default '',
  MajSolde char(1) NOT NULL default '',
  Comment text NOT NULL,
  PRIMARY KEY  (IdTypMvt)
) ENGINE=MyISAM";
  if (!$res=send_sql($dblk, $sql)) $Msg=$Msg."La cration de la base ".$db." a chou sur la table TypeMouvement.<br>";
