<?php
/* ======================================================================================== */
/* Draw_Histogramme_Monoserie.php : Reprsentation de statistiques sous forme d'histogramme */
/* Version   : 1.0        Date : 12-07-2003        Auteur : Jean-Louis BATAILLE             */
/* ======================================================================================== */
/* Draw_Histogramme_Monoserie.php : Correction si ValeurMaxi=ValeurMini                     */
/* Version   : 1.1        Date : 17-10-2003        Auteur : Jean-Louis BATAILLE             */
/* ======================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.2           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.3           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.2           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* ---------------------------------------------------------------------------------------- */
/* $Tab_Stats        : tableau de statistiques  illustrer sous forme d'histogramme         */
/* $ImgLarg          : largeur de l'image demande                                          */
/* $ImgHaut          : hauteur de l'image rsultante                                        */
/* $ImgMarge         : marge entre le bord de l'image et le graphe                          */
/* $IntervalleLarg   : largeur de l'intervalle                                              */
/* $Titre            : titre du graphique                                                   */
/* $CouleurPos       : couleur de remplissage de l'histogramme pour les valeurs positives   */
/* $CouleurNeg       : couleur de remplissage de l'histogramme pour les valeurs ngatives   */
/* $NbLigneAbscisse  : nombre de lignes rseves pour l'affichage des abscisses             */
/* $SepLigneAbscisse : sparateur de lignes pour l'affichage des abscisses                  */
/* $filename         : nom de l'image rsultante                                            */
/*                                                                                          */
/* La fonction retourne la valeur true en cas de cration de l'image avec succs            */
/*                   et la valeur false en cas d'chec                                      */
/* ---------------------------------------------------------------------------------------- */
function Draw_Histogramme_Monoserie($Tab_Stats,$ImgLarg,$ImgHaut,$ImgMarge,$IntervalleLarg,$Titre,$CouleurPos,$CouleurNeg,$NbLigneAbscisse,$SepLigneAbscisse,$filename){
if (!is_array($Tab_Stats) || ($ImgLarg<=0) || ($ImgHaut<=0) || ($ImgMarge<=0)) return false; 

$Font=2;$FontTitre=5;
if ($Titre!="") $TitreHaut=imagefontheight($FontTitre)+$ImgMarge;
$Tab_Rub=array_keys($Tab_Stats);         //extrait les rubriques statistiques
$Tab_Val=array_values($Tab_Stats);       //extrait les valeurs statistiques
$NbRub=sizeof($Tab_Rub);                 //dtermine le nombre de rubriques
if ($NbRub==0) return false;
$ValeurMini=0;$ValeurMaxi=0;
foreach ($Tab_Val as $Valeur) {
 if ($Valeur<$ValeurMini) $ValeurMini=$Valeur;  //calcul de la valeur mini
 if ($Valeur>$ValeurMaxi) $ValeurMaxi=$Valeur;  //calcul de la valeur maxi
}
if ($ValeurMaxi==$ValeurMini) $ValeurMaxi=$ValeurMini+1;
$NbCarRubMax=0;
foreach ($Tab_Rub as $Rubrique) {
 if ($NbLigneAbscisse>1) {
  $Tab_Rub_Elem=explode("$SepLigneAbscisse",$Rubrique);
  foreach($Tab_Rub_Elem as $Rubrique_Elem) {
   if (strlen($Rubrique_Elem)>$NbCarRubMax) $NbCarRubMax=strlen($Rubrique_Elem); //nombre de caractres de la rubrique la plus longue
  }
 } else {
  if (strlen($Rubrique)>$NbCarRubMax) $NbCarRubMax=strlen($Rubrique); //nombre de caractres de la rubrique la plus longue
 }
}
if (($NbCarRubMax+2)*imagefontwidth($Font)*$NbRub>$ImgLarg) $ImgLarg=($NbCarRubMax+2)*imagefontwidth($Font)*$NbRub;
 
$Image=imagecreate($ImgLarg,$ImgHaut);   //cration de l'image aux dimensions indiques
$Blanc=imagecolorallocate($Image,255,255,255); 
$Noir=imagecolorallocate($Image,0,0,0);
$CouleurDec=hexdec($CouleurNeg);
$R=floor($CouleurDec/65536);$V=floor(($CouleurDec-$R*65536)/256);$B=$CouleurDec-$R*65536-$V*256;
$CoulNeg=imagecolorallocate($Image,$R,$V,$B); 
$CouleurDec=hexdec($CouleurPos);
$R=floor($CouleurDec/65536);$V=floor(($CouleurDec-$R*65536)/256);$B=$CouleurDec-$R*65536-$V*256;
$CoulPos=imagecolorallocate($Image,$R,$V,$B); 
imagefill($Image,0,0,$Blanc);         //remplit le fond de l'image en blanc
imagecolortransparent($Image,$Blanc); //considre le blanc comme transparent

/* ---------------------------------------------------------------------------------------- */
/* le graphique s'inscrit dans la hauteur et la largeur de l'image,                         */
/* ---------------------------------------------------------------------------------------- */
//$OrdonneesLarg=max(strlen($ValeurMini),strlen($ValeurMaxi))*imagefontwidth($Font)+5;
$AbscissesHaut=$NbLigneAbscisse*imagefontheight($Font);

/* ---------------------------------------------------------------------------------------- */
/* recherche et trac de l'chelle des ordonnes                                            */
/* ---------------------------------------------------------------------------------------- */
$NbGradOrdonne=min($ImgHaut/2/imagefontheight($Font),10);
$ValGradOrdonne=($ValeurMaxi-$ValeurMini)/$NbGradOrdonne;
$Exp=floor(Log10($ValGradOrdonne));
$Ent=floor($ValGradOrdonne/pow(10,$Exp));
if ($Ent<2) $Ent=2;
elseif ($Ent<5) $Ent=5;
else $Ent=10;
$ValGradOrdonne=$Ent*pow(10,$Exp);              //Valeur d'une graduation sur l'axe des ordonnes
$NbGradOrdonnePos=ceil($ValeurMaxi/$ValGradOrdonne);   //Nombre de graduations positives
$NbGradOrdonneNeg=floor($ValeurMini/$ValGradOrdonne);  //Nombre de graduations ngatives
$NbGradOrdonne=$NbGradOrdonnePos-$NbGradOrdonneNeg;   //Nombre de graduations totales
$ValGradOrdonneMax=$NbGradOrdonnePos*$ValGradOrdonne; //Valeur maxi sur laxe des ordonnes
$ValGradOrdonneMin=-$NbGradOrdonnePos*$ValGradOrdonne; //Valeur mini sur laxe des ordonnes
$GrapheHaut=$ImgHaut-2*$ImgMarge-$AbscissesHaut-$TitreHaut;
$GradHaut=floor($GrapheHaut/$NbGradOrdonne);    //Hauteur d'une graduation
$GrapheHaut=$GradHaut*$NbGradOrdonne;           //Hauteur du graphe
$OrdonneesLarg=max(strlen($ValGradOrdonneMin),strlen($ValGradOrdonneMax))*imagefontwidth($Font)+5;

$y1=$TitreHaut+$ImgMarge;
$ValOrdonne=$ValGradOrdonne*ceil($ValeurMaxi/$ValGradOrdonne);
for ($i=0;$i<=$NbGradOrdonne;$i++) {
 if (abs($ValOrdonne)<1E-015) $ValOrdonne=0;
 imagestring($Image,$Font,$ImgMarge,$y1-imagefontheight($Font)/2,$ValOrdonne,$Noir);
 imageline($Image,$ImgMarge+$OrdonneesLarg-3,$y1,$ImgLarg-$ImgMarge+3,$y1,$Noir);
 $y1=$y1+$GradHaut;$ValOrdonne=$ValOrdonne-$ValGradOrdonne;
}
imagerectangle($Image,$ImgMarge+$OrdonneesLarg,$TitreHaut+$ImgMarge,$ImgLarg-$ImgMarge,$TitreHaut+$ImgMarge+$GrapheHaut,$Noir); 

/* ---------------------------------------------------------------------------------------- */
/* trac de l'histogramme et de l'chelle des abscisses                                     */
/* ---------------------------------------------------------------------------------------- */
$GradLarg=($ImgLarg-2*$ImgMarge-$OrdonneesLarg)/$NbRub;   //largeur d'une graduation
$RectangleLarg=$GradLarg-$IntervalleLarg;                 //largeur de chaque rectangle de l'histogramme
$y0=$TitreHaut+$ImgMarge+$GradHaut*ceil($ValeurMaxi/$ValGradOrdonne); //ordonne de l'axe des abscisses
$x1=$ImgMarge+$OrdonneesLarg+$IntervalleLarg/2;
for ($i=0;$i<$NbRub;$i++) {
 $y1=$y0-($Tab_Val[$i]*$GrapheHaut/($ValGradOrdonne*$NbGradOrdonne));
 if ($Tab_Val[$i]<0) $Couleur=$CoulNeg;
 else $Couleur=$CoulPos;
 imagefilledrectangle($Image,$x1,min($y0,$y1),$x1+$RectangleLarg,max($y0,$y1),$Couleur);
 $x1=$x1+$GradLarg;
}
$x1=$ImgMarge+$OrdonneesLarg;
for ($i=0;$i<$NbRub;$i++) {
 if ($NbLigneAbscisse>1) {
  $Tab_Rub_Elem=explode("$SepLigneAbscisse",$Tab_Rub[$i]);$y1=$ImgHaut-$ImgMarge-$AbscissesHaut;
  foreach ($Tab_Rub_Elem as $Rubrique_Elem) {
   imagestring($Image,$Font,$x1+($GradLarg-strlen($Rubrique_Elem)*imagefontwidth($Font))/2,$y1,$Rubrique_Elem,$Noir);
   $y1=$y1+imagefontheight($Font);
  }
 } else {
  imagestring($Image,$Font,$x1+($GradLarg-strlen($Tab_Rub[$i])*imagefontwidth($Font))/2,$ImgHaut-$ImgMarge-$AbscissesHaut,$Tab_Rub[$i],$Noir);
 }
 $x1=$x1+$GradLarg;
 imageline($Image,$x1,$TitreHaut+$ImgMarge+$GrapheHaut-3,$x1,$TitreHaut+$ImgMarge+$GrapheHaut+3,$Noir);

}
imagestring($Image,$FontTitre,($ImgLarg-strlen($Titre)*imagefontwidth($FontTitre))/2,$ImgMarge,$Titre,$Noir); 
imagepng($Image, $filename);
imagedestroy($Image);
return true;


} ?>


