<?php
/* ======================================================================================== */
/* Draw_Secteurs.php : Reprsentation de statistiques sous forme de secteurs                */
/* Version   : 1.0     Date : 12-07-2003        Auteur : Jean-Louis BATAILLE                */
/* ======================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.1           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.2           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* ---------------------------------------------------------------------------------------- */
/* $Tab_Stats : tableau de statistiques  illustrer sous forme de secteurs                  */
/* $ImgLarg   : largeur de l'image rsultante                                               */
/* $ImgHaut   : hauteur de l'image rsultante                                               */
/* $ImgMarge  : marge entre le bord de l'image, le graphe et la legende                     */
/* $AffLegende: affichage ou non de la lgende la legende                                   */
/* $filename  : nom de l'image rsultante                                                   */
/*                                                                                          */
/* La fonction retourne la valeur true en cas de cration de l'image avec succs            */
/*                   et la valeur false en cas d'chec                                      */
/* ---------------------------------------------------------------------------------------- */
function Draw_Secteurs($Tab_Stats,$ImgLarg,$ImgHaut,$ImgMarge,$Titre,$AffLegende,$filename){
if (!is_array($Tab_Stats) || ($ImgLarg<=0) || ($ImgHaut<=0) || ($ImgMarge<=0)) return false; 

$LegendeInterLigne=5;
$LegendeHauteurLigne=15;
$Font=2;$FontTitre=5;
$TitreHaut=($Titre!="") ? imagefontheight($FontTitre)+$ImgMarge : 0;
$ListeCouleurs=Array("#ff0000","#ffff00","#00ff00","#0000ff","#ff7fff","#7f007f","#ff7f00","#007f00",
                     "#00ffff","#7f7fff","#ff007f","#7f7f7f","#7f7f00","#ffff7f","#7fff7f","#00007f");
$Tab_Rub=array_keys($Tab_Stats);         //extrait les rubriques statistiques
$Tab_Val=array_values($Tab_Stats);       //extrait les valeurs statistiques
$NbRub=sizeof($Tab_Rub);                 //dtermine le nombre de rubriques (pour la lgende)
if ($NbRub==0) return false;
$Total=array_sum($Tab_Val);              //Somme les valeurs statistiques
//foreach ($Tab_Val as $Valeur) {
// echo $Valeur."<br>";
//}
if ($Total==0) return false;
 
$Image=imagecreate($ImgLarg,$ImgHaut);   //cration de l'image aux dimensions indiques
$Bluelanc=imagecolorallocate($Image,255,255,255); 
$Noir=imagecolorallocate($Image,0,0,0); 
imagefill($Image,0,0,$Bluelanc);         //remplit le fond de l'image en blanc
imagecolortransparent($Image,$Bluelanc); //considre le blanc comme transparent

/* ---------------------------------------------------------------------------------------- */
/* Dtermination de la rubrique la plus longue et de la largeur de la lgende               */
/* La lgende occupe au maximum, le tiers droit ou plus si la hautuer de l'image est petite */
/* ---------------------------------------------------------------------------------------- */
if (!$AffLegende) $Diametre=min($ImgHaut,$ImgLarg)-2*$ImgMarge;
else {
 $RubMaxCar=0;
 foreach ($Tab_Rub as $Rub) {
  if (strlen($Rub)>$RubMaxCar) $RubMaxCar=strlen($Rub); 
 }
 $LegendeLarg=$RubMaxCar*imagefontwidth($Font)+2*$ImgMarge+15;
 if ($ImgHaut-$TitreHaut<$ImgLarg*2/3) {
  $Diametre=$ImgHaut-$TitreHaut-2*$ImgMarge; 
  if ($LegendeLarg>$ImgLarg-$Diametre-3*$ImgMarge) $LegendeLarg=$ImgLarg-$Diametre-3*$ImgMarge;
 } else {
  if ($LegendeLarg>$ImgLarg/3-$ImgMarge) $LegendeLarg=$ImgLarg/3-ImgMarge;
  $Diametre=$ImgLarg-$LegendeLarg-3*$ImgMarge; 
 }
}
  
/* ---------------------------------------------------------------------------------------- */
/* le graphique s'inscrit dans la hauteur ou les deux tiers de la largeur de l'image,       */
/* allign plutt en haut et  gauche de l'image                                            */
/* ---------------------------------------------------------------------------------------- */
$Centre_x=round($Diametre/2)+$ImgMarge; 
$Centre_y=round($Diametre/2)+$TitreHaut+$ImgMarge;

/* ---------------------------------------------------------------------------------------- */
/* la lgende occupe le tiers de droite ou plus si la hautuer de l'image est petite,        */
/* alligne plutt en haut et  droite de l'image                                           */
/* ---------------------------------------------------------------------------------------- */
if ($AffLegende) {
 $LegendeHaut=min($LegendeInterLigne+($LegendeInterLigne+$LegendeHauteurLigne)*$NbRub,$ImgHaut-$TitreHaut-2*$ImgMarge); 
 imagerectangle($Image,$ImgLarg-$LegendeLarg-$ImgMarge,$TitreHaut+$ImgMarge,$ImgLarg-$ImgMarge,$TitreHaut+$ImgMarge+$LegendeHaut,$Noir); 
 $Legende_y=$TitreHaut+$ImgMarge+$LegendeInterLigne; 
 $LegendeMaxCar=round(($LegendeLarg-15-2*$ImgMarge)/imagefontwidth($Font));
}

/* ---------------------------------------------------------------------------------------- */
/* constitution du graphe et de la lgende (attribution des couleurs, rubriques et          */
/* tiquettes                                                                               */
/* ---------------------------------------------------------------------------------------- */
srand((double)microtime()*1000000);                      //initialisation de la fonction alatoire
$AngleDeb = 270;                                         //angle de dpart
for($i=0;$i<$NbRub;$i++) {
 if ($i<sizeof($ListeCouleurs)) {
  $temp=hexdec($ListeCouleurs[$i]);
  $Red=floor($temp/65536);$temp=$temp-$Red*65536;
  $Green=floor($temp/256);
  $Blue=$temp-$Green*256;
 } else {
  $Red=rand(1,254);$Green=rand(1,254);$Blue=rand(1,254);
 }
 $Color=imagecolorallocate($Image,$Red,$Green,$Blue); 

 if ($i==$NbRub-1) $AngleFin=630;                         //angle de fin
 else $AngleFin=round($AngleDeb+$Tab_Val[$i]/$Total*360);
 imagefilledarc($Image,$Centre_x,$Centre_y,$Diametre,$Diametre,$AngleDeb,$AngleFin,$Color,IMG_ARC_EDGED); 
 $AngleDeb=$AngleFin;                                    //angle de dbut de secteur = angle de fin de secteur prcdent
  
 if ($AffLegende) {                        //ne pas dpasser le cadre bas de la lgende
  if ($Legende_y<($LegendeHaut+$TitreHaut)) {                        //ne pas dpasser le cadre bas de la lgende
   $LegendeCoul_x1=$ImgLarg-$LegendeLarg;                 //abscisse du coin suprieur gauche de la teinte de lgende
   $LegendeCoul_y1=$Legende_y;                            //ordonne du coin suprieur gauche de la teinte de lgende
   imagefilledrectangle($Image,$LegendeCoul_x1,$LegendeCoul_y1,$LegendeCoul_x1+15,$LegendeCoul_y1+15,$Color); 
   imagestring($Image,$Font,$LegendeCoul_x1+20,$Legende_y,substr($Tab_Rub[$i],0,$LegendeMaxCar),$Noir); 
  } 
  $Legende_y=$Legende_y+$LegendeInterLigne+15;
 } 
}
if ($AffLegende) { 
 $AngleDeb=270;                                           //angle de dpart
 for($i=0;$i<$NbRub;$i++) {
  $AngleFin=round($AngleDeb+$Tab_Val[$i]/$Total*360);     //angle de fin
  $Milieu=round(($AngleFin+$AngleDeb)/2);
  if ($Milieu<450 and $AngleFin-$AngleDeb<10) {
   $Milieu_x=round(cos(deg2rad($AngleDeb))*($Diametre*3/8)+$Centre_x);
   $Milieu_y=round(sin(deg2rad($AngleDeb))*($Diametre*3/8)+$Centre_y);
  } else {
   $Milieu_x=round(cos(deg2rad($Milieu))*($Diametre*3/8)+$Centre_x);
   $Milieu_y=round(sin(deg2rad($Milieu))*($Diametre*3/8)+$Centre_y);
  }
  imagestring($Image,2,$Milieu_x,$Milieu_y,number_format($Tab_Val[$i],'0','.',' '),$Noir); 
  $AngleDeb=$AngleFin; 
 }
}
imagearc($Image,$Centre_x,$Centre_y,$Diametre,$Diametre,0,360,$Noir); 
imagestring($Image,$FontTitre,($ImgLarg-strlen($Titre)*imagefontwidth($FontTitre))/2,1,$Titre,$Noir); 
imagepng($Image, $filename);
imagedestroy($Image);
if (!file_exists($filename)) return false; 
return true; 
} ?>