<?php
/* ===================================================================================== */
/* OperationCourante.php : Caractristiques d'une opration courante                     */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML                                                  */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction CheckDate par ControleDate                 */
/* Version   : 1.2           Date : 07-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Rcupration des modes de rglement et des rubriques, au chargement de */
/*                la page, plutt qu'au changement du sens de l'opration                */
/* Version   : 1.3           Date : 18-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit Mozilla                                                  */
/* Version   : 1.4           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de ; aprs &nbsp dans <p class=msg>&nbsp...                      */
/*                Interdiction de saisir des espaces dans le montant                     */
/*                Abandon du contrle de la saisie si bouton Annuler                     */
/* Version   : 1.5           Date : 15-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Affichage de la liste de tous les modes de rglement  dfaut de       */
/*                mode de rglement explicitement autoris pour le compte                */
/* Version   : 1.6           Date : 24-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.7           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.8           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.8";

$titre="Caractristiques de l'opration courante";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);          //Connexion et Slection de la base de donnes
include("./Includes/OperationCourante_save.php");    //Constantes de l'application
include("./Includes/Recup_Compte.php");    //Rcupration du compte : $Compte

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des types de transaction pour liste droulante : $rsTypesMouvement          */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdTypMvt,LibTypMvt FROM TypeMouvement ORDER BY LibTypMvt";
  $rsTypesMouvement=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des proprits de l'opration courante : $OpeCour                           */
/* ---------------------------------------------------------------------------------------- */
  if ($PosOpe!=="N") {
   $sql="SELECT * FROM CompteOpeCour WHERE IdCpt='".$_SESSION['CompteRefer']."' and IdLibMvt='".$_SESSION['OpeCours'][$PosOpe]."'";
   $rsOpeCour=send_sql($dblk, $sql);$OpeCour=mysqli_fetch_array($rsOpeCour,MYSQLI_ASSOC);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des imputations de l'opration courante : $rsOpeCourRubriques                       */
/* ---------------------------------------------------------------------------------------- */
   $sql="SELECT CompteOpeCourRubrique.IdNature,LibNature,MntImp FROM CompteOpeCourRubrique,Rubrique ";
   $sql=$sql."WHERE CompteOpeCourRubrique.IdNature=Rubrique.IdNature and ";
   $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and IdLibMvt='".$_SESSION['OpeCours'][$PosOpe]."' ORDER BY LibNature";
   $rsOpeCourRubriques=send_sql($dblk, $sql);
  }
/* ---------------------------------------------------------------------------------------- */
/* Prparation de l'affichage des champs du formulaire                                      */
/* ---------------------------------------------------------------------------------------- */
  $Status=($PosOpe==="N") ? AddSlashes($titre." (nouvelle opration)") : AddSlashes($titre." (".($PosOpe+1)." sur ".count($_SESSION['OpeCours']).")"); //defaultStatus
  if (!isset($Msg)) {
   if ($PosOpe==="N") {
    $valeur_init['IdLibMvt']="";
    $valeur_init['LibMvt']="";
    $valeur_init['ModMvt']="";
    $valeur_init['TypMvt']="";
    $valeur_init['MntMvt']="";
    $valeur_init['SensMvt']="";
    $valeur_init['NatMvt']="";
    $valeur_init['Actif']="";
    $valeur_init['OpePer']="";
    $valeur_init['LgPer']="";
    $valeur_init['UnitPer']="";
    $valeur_init['ProchEch']="";
    $valeur_init['DernEch']="";
    $MotMvt="";
   } else {
    $valeur_init['IdLibMvt']=$OpeCour['IdLibMvt'];
    $valeur_init['LibMvt']=$OpeCour['LibMvt'];
    $valeur_init['ModMvt']=$OpeCour['ModMvt'];
    $valeur_init['TypMvt']=$OpeCour['TypMvt'];
    $valeur_init['MntMvt']=$OpeCour['MntMvt'];
    $valeur_init['SensMvt']=$OpeCour['SensMvt'];
    $valeur_init['NatMvt']="";
    if (mysqli_num_rows($rsOpeCourRubriques)==1) {
     $rec=mysqli_fetch_array($rsOpeCourRubriques,MYSQLI_ASSOC);
     if ($rec['MntImp']==$OpeCour['MntMvt']) $valeur_init['NatMvt']=$rec['IdNature'];
    }
    $valeur_init['Actif']=$OpeCour['Actif'];
    $valeur_init['OpePer']=$OpeCour['OpePer'];
    $valeur_init['LgPer']=$OpeCour['LgPer'];
    $valeur_init['UnitPer']=$OpeCour['UnitPer'];
    $valeur_init['ProchEch']=($OpeCour['ProchEch']=="0000-00-00") ? "" : invDate($OpeCour['ProchEch'],"-","JMAA");
    $valeur_init['DernEch']=($OpeCour['DernEch']=="0000-00-00") ? "" : invDate($OpeCour['DernEch'],"-","JMAA");
    $MotMvt=$OpeCour['MotMvt'];
   }
  }
?>

<HTML>
<HEAD>
<TITLE>Caractristiques d'une opration courante</TITLE>
<META name="description" content="Description d'une opration courante">
<META name="keywords" content=""> 
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">

<!------------------------------------------------------------------------------------------->
<script language="javascript">
/* ======================================================================================== */
<?php
/* ---------------------------------------------------------------------------------------- */
/* Initialisation des tables javascript des modes de rglement autoriss pour les dpenses  */
/*            jsModeReglDep, les recettes jsModeReglRec et en gnral jsModeReglGen         */
/* ---------------------------------------------------------------------------------------- */

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des modes de rglement pour liste droulante : $rsModesReglementGen         */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteModeRegl.IdModRegl,LibModRegl FROM CompteModeRegl,ModeReglement ";
  $sql=$sql."WHERE CompteModeRegl.IdModRegl=ModeReglement.IdModRegl and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and (ActDepense='O' or ActRecette='O') ORDER BY LibModRegl";
  $rsModesReglementGen=send_sql($dblk, $sql);
  $nbModeReglementAutorise=mysqli_num_rows($rsModesReglementGen);
  if ($nbModeReglementAutorise<=0) {
   $sql="SELECT IdModRegl,LibModRegl FROM ModeReglement ORDER BY LibModRegl";
   $rsModesReglementGen=send_sql($dblk, $sql);
  } $i=1;
  echo "  var jsIdModReglGen=new Array; var jsLibModReglGen=new Array;\n";
  while ($ModesReglementGen = mysqli_fetch_array($rsModesReglementGen,MYSQLI_ASSOC)) {
   echo "  jsIdModReglGen[".$i."]='".$ModesReglementGen['IdModRegl']."';";
   echo "  jsLibModReglGen[".$i++."]='".AddSlashes($ModesReglementGen['LibModRegl'])."';\n";
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des modes de rglement autoriss pour les dpenses : $rsModesReglementDep   */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteModeRegl.IdModRegl,LibModRegl FROM CompteModeRegl,ModeReglement ";
  $sql=$sql."WHERE CompteModeRegl.IdModRegl=ModeReglement.IdModRegl and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and ActDepense='O' ORDER BY LibModRegl";
  $rsModesReglementDep=send_sql($dblk, $sql);
  if ($nbModeReglementAutorise<=0) {
   $sql="SELECT IdModRegl,LibModRegl FROM ModeReglement ORDER BY LibModRegl";
   $rsModesReglementDep=send_sql($dblk, $sql);
  } $i=1;
  echo "  var jsIdModReglDep=new Array; var jsLibModReglDep=new Array;\n";
  while ($ModesReglementDep = mysqli_fetch_array($rsModesReglementDep,MYSQLI_ASSOC)) {
   echo "  jsIdModReglDep[".$i."]='".$ModesReglementDep['IdModRegl']."';";
   echo "  jsLibModReglDep[".$i++."]='".AddSlashes($ModesReglementDep['LibModRegl'])."';\n";
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des modes de rglement autoriss pour les recettes : $rsModesReglementRec   */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteModeRegl.IdModRegl,LibModRegl FROM CompteModeRegl,ModeReglement ";
  $sql=$sql."WHERE CompteModeRegl.IdModRegl=ModeReglement.IdModRegl and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and ActRecette='O' ORDER BY LibModRegl";
  $rsModesReglementRec=send_sql($dblk, $sql);
  if ($nbModeReglementAutorise<=0) {
   $sql="SELECT IdModRegl,LibModRegl FROM ModeReglement ORDER BY LibModRegl";
   $rsModesReglementRec=send_sql($dblk, $sql);
  } $i=1;
  echo "  var jsIdModReglRec=new Array; var jsLibModReglRec=new Array;\n";
  while ($ModesReglementRec = mysqli_fetch_array($rsModesReglementRec,MYSQLI_ASSOC)) {
   echo "  jsIdModReglRec[".$i."]='".$ModesReglementRec['IdModRegl']."';";
   echo "  jsLibModReglRec[".$i++."]='".AddSlashes($ModesReglementRec['LibModRegl'])."';\n";
  }

/* ---------------------------------------------------------------------------------------- */
/* Initialisation des tables javascript des rubriques privilgies pour les dpenses        */
/* jsCompte_RubriquesDep, les recettes jsCompte_RubriquesRec et en gnral                  */
/* jsCompte_RubriquesGen                                                                    */
/* ---------------------------------------------------------------------------------------- */

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubriques pour liste droulante : $rsCompte_RubriquesGen                */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteRubrique.IdNature,LibNature FROM CompteRubrique,Rubrique ";
  $sql=$sql."WHERE CompteRubrique.IdNature=Rubrique.IdNature and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and (ActDepense='O' or ActRecette='O') ORDER BY LibNature";
  $rsCompte_RubriquesGen=send_sql($dblk, $sql); $i=1;
  echo "  var jsIdRubGen=new Array; var jsLibRubGen=new Array;\n";
  while ($Compte_RubriquesGen = mysqli_fetch_array($rsCompte_RubriquesGen,MYSQLI_ASSOC)) {
   echo "  jsIdRubGen[".$i."]='".$Compte_RubriquesGen['IdNature']."';";
   echo "  jsLibRubGen[".$i++."]='".AddSlashes($Compte_RubriquesGen['LibNature'])."';\n";
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubbriques privilgies pour les dpenses : $rsCompte_RubriquesDep      */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteRubrique.IdNature,LibNature FROM CompteRubrique,Rubrique ";
  $sql=$sql."WHERE CompteRubrique.IdNature=Rubrique.IdNature and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and ActDepense='O' ORDER BY LibNature";
  $rsCompte_RubriquesDep=send_sql($dblk, $sql); $i=1;
  echo "  var jsIdRubDep=new Array; var jsLibRubDep=new Array;\n";
  while ($Compte_RubriquesDep = mysqli_fetch_array($rsCompte_RubriquesDep,MYSQLI_ASSOC)) {
   echo "  jsIdRubDep[".$i."]='".$Compte_RubriquesDep['IdNature']."';";
   echo "  jsLibRubDep[".$i++."]='".AddSlashes($Compte_RubriquesDep['LibNature'])."';\n";
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubbriques privilgies pour les recettes : $rsCompte_RubriquesRec      */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteRubrique.IdNature,LibNature FROM CompteRubrique,Rubrique ";
  $sql=$sql."WHERE CompteRubrique.IdNature=Rubrique.IdNature and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and ActRecette='O' ORDER BY LibNature";
  $rsCompte_RubriquesRec=send_sql($dblk, $sql); $i=1;
  echo "  var jsIdRubRec=new Array; var jsLibRubRec=new Array;\n";
  while ($Compte_RubriquesRec = mysqli_fetch_array($rsCompte_RubriquesRec,MYSQLI_ASSOC)) {
   echo "  jsIdRubRec[".$i."]='".$Compte_RubriquesRec['IdNature']."';";
   echo "  jsLibRubRec[".$i++."]='".AddSlashes($Compte_RubriquesRec['LibNature'])."';\n";
  }
 ?>   
/* ---------------------------------------------------------------------------------------- */
/* Fonctions gnrales                                                                      */
/* ---------------------------------------------------------------------------------------- */
<?php include("./Includes/ControleDate.js");  //ControleDate(d) : Contrle du format JJ-MM-AAAA de la date d
?>
/* ---------------------------------------------------------------------------------------- */
/* Contrle des valeurs des champs du formulaire                                            */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(form) {
if (form.Mode.value=="A") return true;
if (form.Mode.value=="S") return window.confirm("Confirmez-vous la suppression de cette opration ?");

 if (form.IdLibMvt.value.replace(RegExp(" ","g"),"")=="") {
  alert("L\'identifiant de l\'opration courante est une information  saisir obligatoirement")
  form.IdLibMvt.focus()
  return false
 }
 if ((form.IdLibMvt.value.indexOf('\'')!=-1) || (form.IdLibMvt.value.indexOf('\\')!=-1)) {
  alert("L\'identifiant de l\'opration courante contient un caractre spcial interdit, une apostrophe ou un \\ peut-tre.")
  form.IdLibMvt.focus()
  return false
 }
 if (form.LibMvt.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le libell de l\'opration courante est une information  saisir obligatoirement")
  form.LibMvt.focus()
  return false
 }
 if (form.SensMvt.value=="") {
  alert("Le sens de l\'opration courante est une information  slectionner obligatoirement")
  form.SensMvt.focus()
  return false
 }
 if (form.TypMvt.value=="") {
  alert("Le type de l\'opration courante est une information  slectionner obligatoirement")
  form.TypMvt.focus()
  return false
 }
 if (form.ModMvt.value=="") {
  alert("Le mode de rglement de l\'opration courante est une information  slectionner obligatoirement")
  form.ModMvt.focus()
  return false
 }
 if (form.MntMvt.value.replace(RegExp(" ","g"),"")=="") form.MntMvt.value=0;
 if (isNaN(form.MntMvt.value)) {
  alert("Le montant de l\'opration courante est une information numrique")
  form.MntMvt.focus()
  return false
 }
 if ((form.MotMvt.value.indexOf('\n')!=-1)) {
  alert("Les retours  la ligne ne sont pas autoriss dans le motif d\'une opration courante.")
  form.MotMvt.focus()
  return false
 }
 if (!form.OpePer[0].checked && !form.OpePer[1].checked) {
  alert("Slectionner oui s\'il s\'agit d\'une opration priodique ou non sinon."); 
  form.OpePer[0].focus()
  return false;
 }
/******** Opration priodique ***********/
 if (form.OpePer[0].checked) { 
  if (form.LgPer.value.replace(RegExp(" ","g"),"")=="" || form.LgPer.value==0) {
   alert("La priodicit des chances est une information  saisir obligatoirement en cas d\'opration priodique.")
   form.LgPer.focus()
   return false;
  } 
  if (isNaN(form.LgPer.value)) {
   alert("La priodicit des chances est une information numrique.")
   form.LgPer.focus()
   return false
  }
  if (form.UnitPer.value=="") {
   alert("L\'unit de priodicit entre deux chances est une information  saisir obligatoirement en cas d\'opration priodique.")
   form.UnitPer.focus()
   return false;
  } 
  if (form.ProchEch.value=="") {
   alert("La date de la prochaine chance est une information  saisir obligatoirement au format JJ-MM-AAAA")
   form.ProchEch.focus()
   return false;
  } 
  if (!ControleDate(form.ProchEch.value)) {
   alert("La date de la prochaine chance est une information  saisir obligatoirement au format JJ-MM-AAAA");
   form.ProchEch.focus()
   return false;
  }
  if (form.DernEch.value!="" && !ControleDate(form.DernEch.value)) {
   alert("La date de la dernire chance est une information  saisir au format JJ-MM-AAAA");
   form.DernEch.focus()
   return false;
  } 
 } 
 return true
}
/* ---------------------------------------------------------------------------------------- */
/* Changement du SENS DE L'OPERATION                                                        */
/* ---------------------------------------------------------------------------------------- */
function SensMvt_Change(SensMvt,ModMvt,NatMvt) {
 for (i = ModMvt.length - 1; i >= 0; i--) {
  ModMvt.options[i] = null;
 }
 var jsIdModRegl = new Array;var jsLibModRegl = new Array;
 switch (SensMvt.value) {
  case 'D':jsIdModRegl=jsIdModReglDep;jsLibModRegl=jsLibModReglDep;break;
  case 'R':jsIdModRegl=jsIdModReglRec;jsLibModRegl=jsLibModReglRec;break;
  default :jsIdModRegl=jsIdModReglGen;jsLibModRegl=jsLibModReglGen;break;
 }
 ModMvt.length = jsIdModRegl.length; 
 if (ModMvt.length==0) ModMvt.length=1;
 ModMvt.options[0].value='';ModMvt.options[0].text='non dtermin';
 for (i = 1; i < ModMvt.length; i++) {
  ModMvt.options[i].value = jsIdModRegl[i];
  ModMvt.options[i].text = jsLibModRegl[i];
  if ('<?php echo $valeur_init['ModMvt']; ?>'==ModMvt.options[i].value) ModMvt.options[i].selected=true;
 }

 for (i = NatMvt.length - 1; i >= 0; i--) {
  NatMvt.options[i] = null;
 }
 var jsIdRub = new Array;var jsLibRub = new Array;
 switch (SensMvt.value) {
  case 'D':jsIdRub=jsIdRubDep;jsLibRub=jsLibRubDep;break;
  case 'R':jsIdRub=jsIdRubRec;jsLibRub=jsLibRubRec;break;
  default :jsIdRub=jsIdRubGen;jsLibRub=jsLibRubGen;break;
 }
 NatMvt.length = jsIdRub.length;
 if (NatMvt.length==0) NatMvt.length=1;
 NatMvt.options[0].value='';NatMvt.options[0].text='non dtermine ou multiple';
 for (i = 1; i < NatMvt.length; i++) {
  NatMvt.options[i].value = jsIdRub[i];
  NatMvt.options[i].text = jsLibRub[i];
  if ('<?php echo $valeur_init['NatMvt']; ?>'==NatMvt.options[i].value) NatMvt.options[i].selected=true;
 }
}
</script>
</HEAD>

<BODY onLoad="top.document.title='Opration courante';window.defaultStatus='<?php echo $Status; ?>';SensMvt_Change(document.forms[0].SensMvt,document.forms[0].ModMvt,document.forms[0].NatMvt)">
<table border=0 cellspacing=0 cellpadding=0> <!----- Directives d'entte ----->
 <tr>
  <td class=tdleft>
   <?php if ($PosOpe>0 and $PosOpe!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosOpe=<?php echo ($PosOpe-1); ?>" title="Accder  l'opration prcdente">Prcdent</a><?php
      } else echo "Prcdent"; ?></td>
  <td class=tdleft>
   <?php if ($PosOpe<count($_SESSION['OpeCours'])-1 and $PosOpe!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosOpe=<?php echo ($PosOpe+1); ?>" title="Accder  l'opration suivante">Suivant</a><?php
      } else echo "Suivant"; ?></td>
  <td class=tdleft>
   <?php if ($PosOpe!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosOpe=N" title="Crer une opration">Nouveau</a><?php
      } else echo "Nouveau"; ?></td>
  <td class=tdleft>
   <a href="OperationsCourantes.php" title="Retour  la liste des oprations courantes">Retour</a></td>
  <td class=tdleft>
   <a href="Help/OperationCourante_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>                                                   <!-- Fin de directives d'entte -->
<hr size=2 width="100%"><!----------------------------------------------------------->
<!------------------------------------- Dbut de formulaire --------------------------------->
<form action="OperationCourante.php" method="post" onSubmit="return control_saisie(this)">
<input type="hidden" name="PosOpe" value="<?php echo $PosOpe; ?>"> <!-- Transmission  OperationCourante_save.php -->
<input type="hidden" name="Mode" value=""> <!-- = "S" si bouton Supprimer activ, "A" si Annuler -->
<h3><?php echo $Compte['IntCpt']; ?></h3>
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>Code</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="IdLibMvt" SIZE="6" maxlength="6" value="<?php echo $valeur_init['IdLibMvt']; ?>"
    onMouseOver="javascript:window.status='Identifiant obligatoire de l\'opration courante'"></td></tr>
 <tr>
  <td class=tdleft>Opration</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="LibMvt" SIZE="25" maxlength="30" value="<?php echo $valeur_init['LibMvt']; ?>"
    onMouseOver="javascript:window.status='Libell obligatoire de l\'opration courante'"></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>
   <select name="SensMvt" onMouseOver="javascript:window.status='Dtermine le sens de l\'opration courante'"
    onChange="javascript:SensMvt_Change(SensMvt,ModMvt,NatMvt)">
    <option value="">non dtermin</option>
    <option value="D" <?php if ($valeur_init['SensMvt']=="D") echo "selected"; ?>>Dpense</option>
    <option value="R" <?php if ($valeur_init['SensMvt']=="R") echo "selected"; ?>>Recette</option>
   </select></td>
  <td class=tdleft> 
   <select name="TypMvt" onMouseOver="javascript:window.status='La slection d\'un type de transaction permettra de proposer la mise  jour ou non du solde du compte'">
	<option value="">non dtermin</option><?php
     while($TypesMouvement=mysqli_fetch_array($rsTypesMouvement,MYSQLI_ASSOC)) {
      ($valeur_init['TypMvt']==$TypesMouvement['IdTypMvt']) ? $selected="selected" : $selected=""; ?>
	  <option value="<?php echo $TypesMouvement['IdTypMvt']; ?>" <?php echo $selected; ?>><?php echo $TypesMouvement['LibTypMvt']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Par</td>
  <td class=tdleft> 
   <select name="ModMvt" onMouseOver="javascript:window.status='La slection d\'un mode de rglement permet de proposer la date de valeur du rglement'">
	<option value="">non dtermin</option><?php
     switch ($valeur_init['SensMvt']) {
      case "D":$rsModesReglement=$rsModesReglementDep;break;
      case "R":$rsModesReglement=$rsModesReglementRec;break;
      default :$rsModesReglement=$rsModesReglementGen;break;
     }
     $succ=mysqli_data_seek($rsModesReglement,0);
     while($ModesReglement=mysqli_fetch_array($rsModesReglement,MYSQLI_ASSOC)) {
      ($valeur_init['ModMvt']==$ModesReglement['IdModRegl']) ? $selected="selected" : $selected=""; ?>
	<option value="<?php echo $ModesReglement['IdModRegl']; ?>" <?php echo $selected; ?>><?php echo $ModesReglement['LibModRegl']; ?></option><?php
      } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Montant</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="MntMvt" SIZE="17" maxlength="17" style="text-align:right" value="<?php echo $valeur_init['MntMvt']; ?>"
   onMouseOver="javascript:window.status='Montant de l\'opration'"><?php echo " ",$Compte['Format']; ?></td></tr>
 <tr>
  <td class=tdleft>Modle actif</td>
  <td class=tdleft>
   <INPUT TYPE="CHECKBOX" name="Actif" <?php if ($valeur_init['Actif']=="O") echo "checked"; ?>
    onMouseOver="javascript:window.status='Cocher la case pour que le modle apparaisse dans les listes de slection'"></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Motif</td>
  <td class=tdleft colspan="3">
   <TEXTAREA name="MotMvt" ROWS="3" COLS="40" 
    onMouseOver="javascript:window.status='Texte libre facultatif'"><?php echo $MotMvt; ?></TEXTAREA></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Affectation</td>
  <td class=tdleft> 
   <select name="NatMvt" onMouseOver="javascript:window.status='La slection d\'une rubrique permet d`\'imputer l\'opration entirement  cette rubrique'">
    <option value="">non dtermine ou multiple</option><?php $succ=mysqli_data_seek($rsCompte_RubriquesGen,0);
      while($Compte_Rubriques=mysqli_fetch_array($rsCompte_RubriquesGen,MYSQLI_ASSOC)) {
      ($valeur_init['NatMvt']==$Compte_Rubriques['IdNature']) ? $selected="selected" : $selected=""; ?>
	<option value="<?php echo $Compte_Rubriques['IdNature']; ?>" <?php echo $selected; ?>><?php echo $Compte_Rubriques['LibNature']; ?></option><?php
      } ?>
   </select></td>
  <td class=tdleft><?php if ($PosOpe!=="N") echo "ou <a href=\"OperationCourante_Rubriques.php?PosOpe=$PosOpe\">Affectation dtaille ...</a>"; ?></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Opration priodique</td>
  <td class=tdleft>
   <input type="radio" name="OpePer" value="O" <?php if ($valeur_init['OpePer']=="O") echo "checked"; ?>
    onMouseOver="javascript:window.status='Opration priodique'">oui&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
   <input type="radio" name="OpePer" value="N" <?php if ($valeur_init['OpePer']=="N") echo "checked"; ?>
    onMouseOver="javascript:window.status='Opration non priodique'">non</td></tr>
 <tr>
  <td class=tdleft>Priodicit</td>
  <td class=tdleft>
   <input TYPE="TEXT" name="LgPer" maxlength="6" size="6" style="text-align:right" value="<?php echo $valeur_init['LgPer']; ?>"
     onMouseOver="javascript:window.status='Valeur de la priode'">
   <select name="UnitPer" onMouseOver="javascript:window.status='La slection d\'une unit permet d\'exprimer le dlai courant entre deux chances'">
    <option value="J" <?php if ($valeur_init['UnitPer']=="J") echo "selected"; ?>>jour(s)</option>
    <option value="M" <?php if ($valeur_init['UnitPer']=="M") echo "selected"; ?>>mois</option>
   </select></td></tr>
 <tr>
  <td class=tdleft>Prochaine chance</td>
  <td class=tdleft>
   <input TYPE="TEXT" name="ProchEch" maxlength="10" size="10" value="<?php echo $valeur_init['ProchEch']; ?>"
     onMouseOver="javascript:window.status='Date de la prochaine chance'"></td></tr>
 <tr>
  <td class=tdleft>Dernire chance</td>
  <td class=tdleft>
   <input TYPE="TEXT" name="DernEch" maxlength="10" size="10" value="<?php echo $valeur_init['DernEch']; ?>"
     onMouseOver="javascript:window.status='Date de la dernire chance'"></td></tr>
</table>                   <!------------------ Fin de zone de saisie ------------------->
<table border=0 cellspacing=0 cellpadding=0 width="100%"> <!---------- Boutons de commande ----------> 
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdbutton><input type="submit" value="Enregistrer" onClick="Mode.value='V'"
    onMouseOver="javascript:window.status='Sauvegarde des caractristiques de l\'opration'"></td>
  <td class=tdbutton><button type="submit" name="Annuler" onClick="Mode.value='A'"
    onMouseOver="javascript:window.status='Annulation des modifications de l\'opration depuis la dernire sauvegarde'">Annuler</button></td>
  <td class=tdbutton><button type="submit" name="Supprimer" <?php if ($PosOpe==="N") echo "disabled"; ?> onClick="Mode.value='S'"
    onMouseOver="javascript:window.status='Demande de suppression de l\'opration'">Supprimer</button></td>
  <td class=tdbutton width="100%"></td>
 </tr>
</table> <!-------------- Fin des boutons de commande ------------------>
<?php if (isset($Msg)) { ?>
 <p class=msg>&nbsp;<?php echo $Msg; ?></p>
<?php } ?>
</form>  <!-------------- Fin de formulaire           ------------------>
</body>
</html>
