<?php
/* ===================================================================================== */
/* Recette.php : Caractristiques d'une recette                                          */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML                                                  */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction CheckDate par ControleDate                 */
/* Version   : 1.2           Date : 07-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit Mozilla                                                  */
/* Version   : 1.3           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de ; aprs &nbsp dans <p class=msg>&nbsp...                      */
/*                Interdiction de saisir des espaces dans le montant                     */
/*                Abandon du contrle de la saisie si bouton Annuler                     */
/* Version   : 1.4           Date : 15-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.5           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.6           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.6";

$titre="Caractristiques de la recette";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);          //Connexion et Slection de la base de donnes
include("./Includes/Recette_save.php");    //Constantes de l'application
include("./Includes/Recup_Compte.php");    //Rcupration du compte : $Compte

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des oprations courantes du compte pour liste droulante: $rsCompte_OpeCour */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdLibMvt,LibMvt FROM CompteOpeCour WHERE IdCpt='".$_SESSION['CompteRefer'];
  $sql=$sql."' and Actif='O' and SensMvt='R' ORDER BY LibMvt";
  $rsCompte_OpeCour=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des modes de rglement pour liste droulante : $rsModesReglement            */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteModeRegl.IdModRegl,LibModRegl,TypRegl,IdentRegl FROM CompteModeRegl,ModeReglement ";
  $sql=$sql."WHERE CompteModeRegl.IdModRegl=ModeReglement.IdModRegl and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and ActRecette='O' ORDER BY LibModRegl";
  $rsModesReglement=send_sql($dblk, $sql);
  if (mysqli_num_rows($rsModesReglement)<=0) {
   $sql="SELECT IdModRegl,LibModRegl,TypRegl,IdentRegl FROM ModeReglement ORDER BY LibModRegl";
   $rsModesReglement=send_sql($dblk, $sql);
  }
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des types de transaction pour liste droulante : $rsTypesMouvement          */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT IdTypMvt,LibTypMvt FROM TypeMouvement ORDER BY LibTypMvt";
  $rsTypesMouvement=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des rubriques pour liste droulante : $rsCompte_Rubriques                   */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT CompteRubrique.IdNature,LibNature FROM CompteRubrique,Rubrique ";
  $sql=$sql."WHERE CompteRubrique.IdNature=Rubrique.IdNature and ";
  $sql=$sql."IdCpt='".$_SESSION['CompteRefer']."' and ActRecette='O' ORDER BY LibNature";
  $rsCompte_Rubriques=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des proprits de la recette : $Mouvement                                   */
/* ---------------------------------------------------------------------------------------- */
  if ($PosMvt!=="N") {
   $sql="SELECT * FROM Mouvement WHERE IdMvt=".$_SESSION['Mouvements'][$PosMvt];
   $rsMouvement=send_sql($dblk, $sql);$Mouvement=mysqli_fetch_array($rsMouvement,MYSQLI_ASSOC);
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des imputations de la recette : $rsMouvementRubriques                       */
/* ---------------------------------------------------------------------------------------- */
   $sql="SELECT IdNature,MntImp FROM MouvementRubrique WHERE IdMvt='".$_SESSION['Mouvements'][$PosMvt]."'";
   $rsMouvementRubriques=send_sql($dblk, $sql);
  }
/* ---------------------------------------------------------------------------------------- */
/* Prparation de l'affichage des champs du formulaire                                      */
/* ---------------------------------------------------------------------------------------- */
  $Status=($PosMvt==="N") ? AddSlashes($titre." (nouvelle recette)") : AddSlashes($titre." (".($PosMvt+1)." sur ".count($_SESSION['Mouvements']).")"); //defaultStatus
  if (!isset($Msg)) {
   if ($PosMvt==="N") {
    $valeur_init['DateMvt']=date("d-m-Y");$valeur_init['DateVal']="";$valeur_init['LibMvt']="";
    $valeur_init['ModMvt']="";$valeur_init['TypMvt']="";$valeur_init['MntMvt']="";
    $valeur_init['MajSolde']="";$valeur_init['NatMvt']="";$MotMvt="";
   }
   else {
    $valeur_init['DateMvt']=invDate($Mouvement['DateMvt'],"-","JMAA");
    $valeur_init['DateVal']=invDate($Mouvement['DateVal'],"-","JMAA");
    $valeur_init['LibMvt']=$Mouvement['LibMvt'];
    $valeur_init['ModMvt']=$Mouvement['ModMvt'];
    $valeur_init['TypMvt']=$Mouvement['TypMvt'];
    $valeur_init['MntMvt']=$Mouvement['MntMvt'];
    $valeur_init['MajSolde']=$Mouvement['MajSolde'];
    $valeur_init['NatMvt']="";
    if (mysqli_num_rows($rsMouvementRubriques)==1) {
     $rec=mysqli_fetch_array($rsMouvementRubriques,MYSQLI_ASSOC);
     if ($rec['MntImp']==$Mouvement['MntMvt']) $valeur_init['NatMvt']=$rec['IdNature']; }
    $MotMvt=$Mouvement['MotMvt'];
   }
  }
?>

<HTML>
<HEAD>
<TITLE>Caractristiques d'une recette</TITLE>
<META name="description" content="Description d'une recette">
<META name="keywords" content=""> 
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">

<!------------------------------------------------------------------------------------------->
<script language="javascript"> 
/* ======================================================================================== */

/* ---------------------------------------------------------------------------------------- */
/* Fonctions gnrales                                                                      */
/* ---------------------------------------------------------------------------------------- */
<?php include("./Includes/ControleDate.js");  //ControleDate(d) : Contrle du format JJ-MM-AAAA de la date d
   include("./Includes/AddDelai.js");        //AddDelai(d,D) : Retourne une date au format JJ-MM-AAAA en ajoutant un dlai D (nombre de jours)  une date d au format JJ-MM-AAAA
   include("./Includes/Calcul_DateVal.js");  //Calcul_DateVal(M,d) : Calcule une date au format JJ-MM-AAAA en fonction du mode de rglement M et d' une date d au format JJ-MM-AAAA
?>
/* ---------------------------------------------------------------------------------------- */
/* Initialisation des valeurs des champs du formulaire                                      */
/* ---------------------------------------------------------------------------------------- */
function init() {
 top.document.title="Recette";
 javascript:window.defaultStatus='<?php echo $Status; ?>';
 ModMvt_old='<?php echo $valeur_init['ModMvt']; ?>'; /* Sauvegarde de ModMvt pour le prochain changement */
}
/* ---------------------------------------------------------------------------------------- */
/* Contrle des valeurs des champs du formulaire                                            */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(form) {
 if (form.Mode.value=="A") return true;
 if (form.Mode.value=="S") return window.confirm("Confirmez-vous la suppression de cette recette ?");

 if (form.DateMvt.value=="") {
  alert("La date de la recette est une information  saisir obligatoirement au format JJ-MM-AAAA")
  form.DateMvt.focus();
  return false;
 } 
 if (!ControleDate(form.DateMvt.value)) {
  alert("La date de la recette est une information  saisir obligatoirement au format JJ-MM-AAAA");
  form.DateMvt.focus();
  return false;
 }
 if (form.LibMvt.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le libell de la recette est une information  saisir obligatoirement")
  form.LibMvt.focus();
  return false
 }
 if (form.ModMvt.value=="") {
  alert("Le mode de rglement de recette est une information  slectionner obligatoirement")
  form.ModMvt.focus();
  return false
 }
 if (form.TypMvt.value=="") {
  alert("Le type de la recette est une information  slectionner obligatoirement")
  form.TypMvt.focus();
  return false
 }
 if (form.MntMvt.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le montant de la recette est une information  saisir obligatoirement")
  form.MntMvt.focus();
  return false
 }
 if (isNaN(form.MntMvt.value)) {
  alert("Le montant de la recette est une information numrique")
  form.MntMvt.focus();
  return false
 }
 if (form.DateVal.value=="") {
  alert("La date de valeur du rglement est une information  saisir obligatoirement")
  form.DateVal.focus();
  return false
 }
 if (!ControleDate(form.DateVal.value)) {
  alert("La date de valeur du rglement est une information  saisir obligatoirement au format JJ-MM-AAAA");
  form.DateVal.focus();
  return false;
 }
 return true
}
/* ---------------------------------------------------------------------------------------- */
/* Rcupration de MajSolde suite  changement de TYPE DE TRANSACTION    */
/* ---------------------------------------------------------------------------------------- */
function TypMvt_Change(TypMvt,MajSolde) {
 <?php $sql="SELECT IdTypMvt,MajSolde FROM TypeMouvement";$res=send_sql($dblk, $sql);
    while ($rec = mysqli_fetch_array($res)) {
     echo "if (TypMvt.value=='".$rec[0]."') {\n";
     echo "  MajSolde.checked = ('$rec[1]'=='O') ? true : false; }\n ";
    } ?>
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE LA RECETTE                                                      */
/* ---------------------------------------------------------------------------------------- */
function DateMvt_Change(DateMvt,ModMvt,DateVal) {
 if (!ControleDate(DateMvt.value)) {
  alert("La date de la recette est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateMvt.focus();
  return;
 }
 DateVal.value=Calcul_DateVal(ModMvt,DateMvt.value);
}
function DateMvt_Moins_Click(DateMvt,ModMvt,DateVal) {
 if (!ControleDate(DateMvt.value)) {
  alert("La date de la recette est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateMvt.focus();
  return;
 }
 DateMvt.value=AddDelai(DateMvt.value,-1);
 DateVal.value=Calcul_DateVal(ModMvt,DateMvt.value);
}
function DateMvt_Plus_Click(DateMvt,ModMvt,DateVal) {
 if (!ControleDate(DateMvt.value)) {
  alert("La date de la recette est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateMvt.focus();
  return;
 }
 DateMvt.value=AddDelai(DateMvt.value,1);
 DateVal.value=Calcul_DateVal(ModMvt,DateMvt.value);
}
/* ---------------------------------------------------------------------------------------- */
/* Changement de la DATE DE VALEUR                                                          */
/* ---------------------------------------------------------------------------------------- */
function DateVal_Change(DateVal) {
 if (!ControleDate(DateVal.value)) {
  alert("La date de valeur est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateVal.focus();
  return;
 }
}
function DateVal_Moins_Click(DateVal) {
 if (!ControleDate(DateVal.value)) {
  alert("La date de valeur est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateVal.focus();
  return;
 }
 DateVal.value=AddDelai(DateVal.value,-1);
}
function DateVal_Plus_Click(DateVal) {
 if (!ControleDate(DateVal.value)) {
  alert("La date de valeur est une information  saisir obligatoirement au format JJ-MM-AAAA");
  DateVal.focus();
  return;
 }
 DateVal.value=AddDelai(DateVal.value,1);
}
/* ---------------------------------------------------------------------------------------- */
/* Changement du MODE DE REGLEMENT                                                          */
/* ---------------------------------------------------------------------------------------- */
function ModMvt_Change(ModMvt,DateMvt,DateVal) {
 DateVal.value=Calcul_DateVal(ModMvt,DateMvt.value);
}
/* ---------------------------------------------------------------------------------------- */
/* Changement d'OPERATION COURANTE                                                          */
/* Rcupration de ModRegl, TypMvt, MntMvt et des rubriques                                 */
/* ---------------------------------------------------------------------------------------- */
function OpeCour_Change(OpeCour,LibMvt,TypMvt,ModMvt,MntMvt,MotMvt,NatMvt,MajSolde,DateMvt,DateVal) {
<?php $sql="SELECT IdLibMvt,LibMvt,TypMvt,ModMvt,MntMvt,MotMvt,NatMvt FROM CompteOpeCour ";
   $sql=$sql."WHERE IdCpt='".$_SESSION['CompteRefer']."' and Actif='O' and SensMvt='R'";
   $res=send_sql($dblk, $sql);
   while ($rec = mysqli_fetch_array($res,MYSQLI_ASSOC)) {
    echo " if (OpeCour.value == '".$rec['IdLibMvt']."') {\n";
    echo "  LibMvt.value = '".AddSlashes($rec['LibMvt'])."';\n";
    echo "  TypMvt.value = '".$rec['TypMvt']."';\n";
    echo "  ModMvt.value = '".$rec['ModMvt']."';\n";
    echo "  MntMvt.value = '".$rec['MntMvt']."';\n";
    echo "  MotMvt.value = '".AddSlashes($rec['MotMvt'])."';\n";
    echo "  NatMvt.value = '".$rec['NatMvt']."';\n";
    echo " }\n";
   }
   echo " TypMvt_Change(TypMvt,MajSolde);\n";
   echo " ModMvt_Change(ModMvt,DateMvt,DateVal);\n";
?>
}
</script>
</HEAD>

<BODY onLoad="javascript:init()">
<table border=0 cellspacing=0 cellpadding=0> <!----- Directives d'entte ----->
 <tr>
  <td class=tdleft>
   <?php if ($PosMvt>0 and $PosMvt!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosMvt=<?php echo ($PosMvt-1); ?>" title="Accder  la recette prcdente">Prcdent</a><?php
      } else echo "Prcdent"; ?></td>
  <td class=tdleft>
   <?php if ($PosMvt<count($_SESSION['Mouvements'])-1 and $PosMvt!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosMvt=<?php echo ($PosMvt+1); ?>" title="Accder  la recette suivante">Suivant</a><?php
      } else echo "Suivant"; ?></td>
  <td class=tdleft>
   <?php if ($PosMvt!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosMvt=N" title="Crer une recette">Nouveau</a><?php
      } else echo "Nouveau"; ?></td>
  <td class=tdleft>
   <a href="Recettes.php" title="Retour  la liste des recettes">Retour</a></td>
  <td class=tdleft>
   <a href="Help/Recette_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>                                                   <!-- Fin de directives d'entte -->
<hr size=2 width="100%"><!----------------------------------------------------------->
<!------------------------------------- Dbut de formulaire --------------------------------->
<form action="Recette.php" method="post" onSubmit="return control_saisie(this)">
<input type="hidden" name="PosMvt" value="<?php echo $PosMvt; ?>"> <!-- Transmission  Depense_save.php -->
<input type="hidden" name="Mode" value=""> <!-- = "S" si bouton Supprimer activ, "A" si Annuler -->
<h3><?php echo $Compte['IntCpt']; ?></h3>
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>Modle</td>
  <td class=tdleft> 
   <select name="OpeCour" 
    onMouseOver="javascript:window.status='La slection d\'un modle permet d\'initialiser les valeurs par dfaut'"
    onChange="javascript:OpeCour_Change(OpeCour,LibMvt,TypMvt,ModMvt,MntMvt,MotMvt,NatMvt,MajSolde,DateMvt,DateVal)">
    <option value="">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option><?php
     while($Compte_OpeCour=mysqli_fetch_array($rsCompte_OpeCour,MYSQLI_ASSOC)) { ?>
	<option value="<?php echo $Compte_OpeCour['IdLibMvt']; ?>"><?php echo $Compte_OpeCour['LibMvt']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Recette</td>
  <td class=tdleft> 
   <select name="TypMvt" 
    onMouseOver="javascript:window.status='La slection d\'un type de transaction permet de proposer la mise  jour ou non du solde du compte'"
    onChange="javascript:TypMvt_Change(TypMvt,MajSolde)">
	<option value="">non dtermin</option><?php
     while($TypesMouvement=mysqli_fetch_array($rsTypesMouvement,MYSQLI_ASSOC)) {
      ($valeur_init['TypMvt']==$TypesMouvement['IdTypMvt']) ? $selected="selected" : $selected=""; ?>
	<option value="<?php echo $TypesMouvement['IdTypMvt']; ?>" <?php echo $selected; ?>><?php echo $TypesMouvement['LibTypMvt']; ?></option><?php
     } ?>
   </select></td>
  <td class=tdleft>le</td>
  <td class=tdleft>
   <BUTTON TYPE="BUTTON" name="DateMvt_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de la recette'"
    onClick="javascript:DateMvt_Moins_Click(DateMvt,ModMvt,DateVal)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="DateMvt" SIZE="10" maxlength="10" value="<?php echo $valeur_init['DateMvt']; ?>"
    onMouseOver="javascript:window.status='Date de la recette obligatoire'"
    onChange="javascript:DateMvt_Change(DateMvt,ModMvt,DateVal)">&nbsp
   <BUTTON TYPE="BUTTON" name="DateMvt_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de la recette'"
    onClick="javascript:DateMvt_Plus_Click(DateMvt,ModMvt,DateVal)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td></tr>
 <tr>
  <td class=tdleft>Tiers</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="LibMvt" SIZE="25" maxlength="30" value="<?php echo $valeur_init['LibMvt']; ?>"
   onMouseOver="javascript:window.status='Libell obligatoire de la recette'"></td></tr>
 <tr>
  <td class=tdleft>Par</td>
  <td class=tdleft> 
   <select name="ModMvt" 
    onMouseOver="javascript:window.status='La slection d\'un mode de rglement permet de proposer la date de valeur du rglement'"
    onChange="javascript:ModMvt_Change(ModMvt,DateMvt,DateVal)">
	<option value="">non dtermin</option><?php
     while($ModesReglement=mysqli_fetch_array($rsModesReglement,MYSQLI_ASSOC)) {
      ($valeur_init['ModMvt']==$ModesReglement['IdModRegl']) ? $selected="selected" : $selected=""; ?>
	<option value="<?php echo $ModesReglement['IdModRegl']; ?>" <?php echo $selected; ?>><?php echo $ModesReglement['LibModRegl']; ?></option><?php
     } ?>
   </select></td></tr>
 <tr>
  <td class=tdleft>Montant</td>
  <td class=tdleft colspan="2"> 
   <INPUT TYPE="TEXT" name="MntMvt" SIZE="17" maxlength="17" style="text-align:right" value="<?php echo $valeur_init['MntMvt']; ?>"
    onMouseOver="javascript:window.status='Montant obligatoire de la recette'"><?php echo " ",$Compte['Format'] ?></td>
  <td class=tdleft>
   <INPUT TYPE="CHECKBOX" name="MajSolde" <?php if ($valeur_init['MajSolde']=="O") echo "checked"; ?>
    onMouseOver="javascript:window.status='Cocher la case pour mettre  jour le solde du compte'">Comptabilis</td></tr>
 <tr>
  <td class=tdleft>Valoris le</td>
  <td class=tdleft> 
   <BUTTON TYPE="BUTTON" name="DateVal_Moins"
    onMouseOver="javascript:window.status='Retirer 1 jour  la date de valeur'"
    onClick="javascript:DateVal_Moins_Click(DateVal)"><img src="<?php echo $Gauche; ?>" alt="Gauche"></BUTTON>
   <INPUT TYPE="TEXT" name="DateVal" SIZE="10" maxlength="10" value="<?php echo $valeur_init['DateVal']; ?>"
    onMouseOver="javascript:window.status='Date de valeur obligatoire du rglement'"
    onChange="javascript:DateVal_Change(DateVal)">&nbsp
   <BUTTON TYPE="BUTTON" name="DateVal_Plus"
    onMouseOver="javascript:window.status='Ajouter 1 jour  la date de valeur'"
    onClick="javascript:DateVal_Plus_Click(DateVal)"><img src="<?php echo $Droite; ?>" alt="Droite"></BUTTON></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Motif</td>
  <td class=tdleft colspan="3">
   <TEXTAREA name="MotMvt" ROWS="3" COLS="40" 
    onMouseOver="javascript:window.status='Texte libre facultatif'"><?php echo $MotMvt; ?></TEXTAREA></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Affectation</td>
  <td class=tdleft> 
   <select name="NatMvt" 
    onMouseOver="javascript:window.status='La slection d\'une rubrique permet d`\'imputer la recette entirement  cette rubrique'">
    <option value="">non dtermine ou multiple</option><?php
     while($Compte_Rubriques=mysqli_fetch_array($rsCompte_Rubriques,MYSQLI_ASSOC)) {
      ($valeur_init['NatMvt']==$Compte_Rubriques['IdNature']) ? $selected="selected" : $selected=""; ?>
	<option value="<?php echo $Compte_Rubriques['IdNature']; ?>" <?php echo $selected; ?>><?php echo $Compte_Rubriques['LibNature']; ?></option><?php
     } ?>
   </select></td>
  <td class=tdleft colspan="2">
   <?php if ($PosMvt!=="N") echo "ou <a href=\"Mouvement_Rubriques.php?PosMvt=$PosMvt\">Affectation dtaille ...</a>"; ?></td></tr>
</table>                   <!------------------ Fin de zone de saisie ------------------->
<table border=0 cellspacing=0 cellpadding=0 width="100%"> <!---------- Boutons de commande ----------> 
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdbutton><input type="submit" value="Enregistrer" onClick="Mode.value='V'"
    onMouseOver="javascript:window.status='Sauvegarde des caractristiques de la recette'"></td>
  <td class=tdbutton><button type="submit" name="Annuler" onClick="Mode.value='A'"
    onMouseOver="javascript:window.status='Annulation des modifications de la recette depuis la dernire sauvegarde'">Annuler</button></td>
  <td class=tdbutton><button type="submit" name="Supprimer" <?php if($PosMvt==="N") echo "disabled"; ?> onClick="Mode.value='S'"
    onMouseOver="javascript:window.status='Demande de suppression de la recette'">Supprimer</button></td>
  <td class=tdbutton width="100%"></td>
 </tr>
</table> <!-------------- Fin des boutons de commande ------------------>
<?php if (isset($Msg)) { ?>
 <p class=msg>&nbsp;<?php echo $Msg; ?></p>
<?php } ?>
</form>  <!-------------- Fin de formulaire           ------------------>
</body>
</html>
