<?php
/* ===================================================================================== */
/* Releve_Nouveau.php : Saisie d'un nouveau relev de compte                             */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML                                                  */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction CheckDate par ControleDate                 */
/* Version   : 1.2           Date : 07-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Correction du calcul des cumuls des dpenses et des recettes pointes  */
/*                (Ajout de "and MajSolde='O'")                                          */
/* Version   : 1.3           Date : 16-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de ; aprs &nbsp dans <p class=msg>&nbsp...                      */
/*                Interdiction de saisir des espaces dans le numro de relev            */
/*                Abandon du contrle de la saisie si bouton Annuler                     */
/* Version   : 1.4           Date : 15-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.5           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.6           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.6";

$titre="Nouveau relev de compte";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);          //Connexion et Slection de la base de donnes
include("./Includes/Releve_save.php");     //Mise  jour, s'il y a lieu
include("./Includes/Recup_Compte.php");    //Rcupration du compte : $Compte
/* ---------------------------------------------------------------------------------------- */
/* Rcupration du cumul des dpenses et recettes des transactions pointes $rsCumulMontant */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Sum(MntMvt) as Cumul,SensMvt FROM Mouvement ";
  $sql=$sql."WHERE IdCpt='".$_SESSION['CompteRefer']."' and Pointe=1 and MajSolde='O' Group BY SensMvt";
  $rsCumulMontant=send_sql($dblk, $sql);$CumulDepense=0;$CumulRecette=0;
  while($CumulMontant=mysqli_fetch_array($rsCumulMontant,MYSQLI_ASSOC)) {
   ($CumulMontant['SensMvt']=='D') ? $CumulDepense=$CumulMontant['Cumul'] : $CumulRecette=$CumulMontant['Cumul'];
  }
/* ---------------------------------------------------------------------------------------- */
/* Prparation de l'affichage des champs du formulaire                                      */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT MAX(IdRel) as MaxIdRel from CompteReleve where IdCpt='".$_SESSION['CompteRefer']."'";
  $res=send_sql($dblk, $sql);$DernRel=mysqli_fetch_array($res,MYSQLI_ASSOC);
  $valeur_init['titre']="Caractristiques du relev de compte (nouveau relev)"; //defaultStatus
  if (!isset($Msg)) {
   if ($DernRel['MaxIdRel']==0) {
    $valeur_init['DateRelPrec']="";
    $valeur_init['SoldRelPrec']=$Compte['SoldInit'];   
    $valeur_init['SoldRel']=number_format($Compte['SoldInit']+$CumulRecette-$CumulDepense,2,".","");   
   }
   else {
    $sql="SELECT * from CompteReleve where IdCpt='".$_SESSION['CompteRefer']."' and IdRel=".$DernRel['MaxIdRel'];
    $res2=send_sql($dblk, $sql);$record2=mysqli_fetch_array($res2,MYSQLI_ASSOC);
    $valeur_init['DateRelPrec']=invDate($record2['DateRel'],"-","JMAA");
    $valeur_init['SoldRelPrec']=$record2['SoldRel'];   
    $valeur_init['SoldRel']=number_format($record2['SoldRel']+$CumulRecette-$CumulDepense,2,".","");   
   }
   $valeur_init['DateRel']=date("d-m-Y");
   $valeur_init['NumRel']="";
   $Comment="";
  }
?>

<HTML>
<HEAD>
<TITLE>Caractristiques d'un nouveau relev de compte</TITLE>
<META name="description" content="Description d'un nouveau relev de compte">
<META name="keywords" content=""> 
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">

<!------------------------------------------------------------------------------------------->
<script language="javascript"> 
/* ======================================================================================== */
/* ---------------------------------------------------------------------------------------- */
/* Fonctions gnrales                                                                      */
/* ---------------------------------------------------------------------------------------- */
<?php include("./Includes/ControleDate.js");  //ControleDate(d) : Contrle du format JJ-MM-AAAA de la date d
?>
/* ---------------------------------------------------------------------------------------- */
/* Contrle des valeurs des champs du formulaire                                            */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(form) {
 if (form.Mode.value=="A") return true;
 if (form.NumRel.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le numro du relev est une information  saisir obligatoirement");
  form.NumRel.focus();
  return false;
 } 
 if (form.DateRelPrec.value=="") {
  alert("La date de dbut de relev est une information  saisir obligatoirement au format JJ-MM-AAAA")
  form.DateRelPrec.focus();
  return false;
 } 
 if (!ControleDate(form.DateRelPrec.value)) {
  alert("La date de dbut de relev est une information  saisir obligatoirement au format JJ-MM-AAAA");
  form.DateRelPrec.focus();
  return false;
 }
 if (form.DateRel.value=="") {
  alert("La date de fin de relev est une information  saisir obligatoirement au format JJ-MM-AAAA")
  form.DateRel.focus();
  return false;
 } 
 if (!ControleDate(form.DateRel.value)) {
  alert("La date de fin de relev est une information  saisir obligatoirement au format JJ-MM-AAAA");
  form.DateRel.focus();
  return false;
 }
 return true;
}
</script>
</HEAD>

<BODY onLoad="top.document.title='<?php echo AddSlashes($titre); ?>';window.defaultStatus=status">
<table border=0 cellspacing=0 cellpadding=0> <!----- Directives d'entte ----->
 <tr>
  <td class=tdleft>
   <a href="Releve_Pointage.php" title="Retour au pointage des transactions du compte">Retour</a></td>
  <td class=tdleft>
   <a href="Help/PointageReleve_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>                                                   <!-- Fin de directives d'entte -->
<hr size=2 width="100%"><!----------------------------------------------------------->
<!------------------------------------- Dbut de formulaire --------------------------------->
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" onSubmit="return control_saisie(this)">
<input type="hidden" name="PosRel" value="N"> <!-- Transmission  Releve_save.php -->
<input type="hidden" name="Mode" value=""> <!-- = "A" pour Annuler -->
<h3><?php echo $Compte['IntCpt']; ?></h3>
<table border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td class=tdleft>Numro du relev</td>
  <td class=tdleft>
   <INPUT TYPE="TEXT" name="NumRel" SIZE="10" maxlength="10" value="<?php echo $valeur_init['NumRel']; ?>"
    onMouseOver="javascript:window.status='Numro du relev obligatoire'"></td></tr>
 <tr>
  <td class=tdleft>Solde au </td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="DateRelPrec" SIZE="10" maxlength="10" value="<?php echo $valeur_init['DateRelPrec']; ?>"
    <?php if ($DernRel['MaxIdRel']>0) echo "readonly"; ?>
    onMouseOver="javascript:window.status='Date de dbut de relev obligatoire'"></td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="SoldRelPrec" SIZE="17" style="text-align:right" value="<?php echo $valeur_init['SoldRelPrec']; ?>" readonly
    onMouseOver="javascript:window.status='Solde en dbut de relev obligatoire'"></td></tr>
 <tr>
  <td class=tdleft>Solde au </td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="DateRel" SIZE="10" maxlength="10" value="<?php echo $valeur_init['DateRel']; ?>"
    onMouseOver="javascript:window.status='Date de fin de relev obligatoire'"></td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="SoldRel" SIZE="17" style="text-align:right" value="<?php echo $valeur_init['SoldRel']; ?>" readonly
    onMouseOver="javascript:window.status='Solde en fin de relev obligatoire'"></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Commentaire</td>
  <td class=tdleft colspan="2">
   <TEXTAREA name="Comment" ROWS="3" COLS="40" 
    onMouseOver="javascript:window.status='Texte libre facultatif'"><?php echo $Comment; ?></TEXTAREA></td></tr>
</table>                   <!------------------ Fin de zone de saisie ------------------->
<table border=0 cellspacing=0 cellpadding=0 width="100%"> <!---------- Boutons de commande ----------> 
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdbutton><input type="submit" value="Archiver" onClick="Mode.value='V'"
    onMouseOver="javascript:window.status='Sauvegarde des caractristiques du relev et archivage des transactions pointes'"></td>
  <td class=tdbutton><button type="submit" name="Annuler" onClick="Mode.value='A'"
    onMouseOver="javascript:window.status='Annulation des modifications du relev de compte'">Annuler</button></td>
  <td class=tdbutton width="100%"></td>
 </tr>
</table> <!-------------- Fin des boutons de commande ------------------>
<?php if (isset($Msg)) { ?>
 <p class=msg>&nbsp;<?php echo $Msg; ?></p>
<?php } ?>
</form>  <!-------------- Fin de formulaire           ------------------>
</body>
</html>
