<?php
/* ===================================================================================== */
/* SimulEmprunt.php : Caractristiques d'une simulation d'emprunt                        */
/* Version   : 1.0           Date : 15-07-2002        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Mise au standard HTML                                                  */
/* Version   : 1.1           Date : 01-02-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Remplacement de la fonction CheckDate par ControleDate                 */
/* Version   : 1.2           Date : 07-07-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit Mozilla                                                  */
/* Version   : 1.3           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit Mozilla                                                  */
/* Version   : 1.4           Date : 30-09-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Ajout de ; aprs &nbsp dans <p class=msg>&nbsp...                      */
/*                Interdiction de saisir des espaces dans le numro de relev            */
/*                Abandon du contrle de la saisie si bouton Annuler                     */
/* Version   : 1.5           Date : 15-10-2003        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Compatibilit EasyPHP 1.7 (PHP 4.3.3)                                  */
/* Version   : 1.6           Date : 22-01-2004        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
/* Modification : Migration vers EasyPHP DevServer 14.1 VC11                             */
/*               (Apache 2.4.7 VC11 | MySQL 5.6.15, PHP 5.5.8)                           */
/* Version   : 1.7           Date : 02/09/2015        Auteur : Jean-Louis BATAILLE       */
/* ===================================================================================== */
$version="1.7";

$titre="Caractristiques de la simulation";
session_start();
include("./Includes/Comptes_data.php");    //Constantes de l'application
include("./Includes/MySQL_functions.php"); //Fonctions d'accs  MySQL
$dblk = connect($MySQL_Host, $MySQL_User, $MySQL_Passw, $db);      //Connexion et Slection de la base de donnes
include("./Includes/SimulEmprunt_save.php");    //Mise  jour, s'il y a lieu

/* ---------------------------------------------------------------------------------------- */
/* Rcupration des proprits de la simulation : $SimulEmprunt                             */
/* ---------------------------------------------------------------------------------------- */
if ($PosSimEmp!=="N") {
  $sql="SELECT * FROM SimulEmprunt WHERE NumOrd='".$_SESSION['SimulsEmprunt'][$PosSimEmp]."'";
  $rsSimulEmprunt=send_sql($dblk, $sql);$SimulEmprunt=mysqli_fetch_array($rsSimulEmprunt,MYSQLI_ASSOC);
}
/* ---------------------------------------------------------------------------------------- */
/* Rcupration des comptes d'emprunt : $rsCompte                                           */
/* ---------------------------------------------------------------------------------------- */
  $sql="SELECT Compte.IdCpt,IntCpt FROM Compte LEFT JOIN Emprunt ON Compte.IdCpt=Emprunt.IdCpt ";
  $sql=$sql."WHERE UsCpt='P' and Actif='O' and Emprunt.IdCpt is null ORDER BY NumOrd";
  $rsCompte=send_sql($dblk, $sql);
/* ---------------------------------------------------------------------------------------- */
/* Prparation de l'affichage des champs du formulaire                                      */
/* ---------------------------------------------------------------------------------------- */
  $Status=($PosSimEmp==="N") ? AddSlashes($titre." (nouvelle simulation)") : AddSlashes($titre." (".($PosSimEmp+1)." sur ".count($_SESSION['SimulsEmprunt']).")"); //defaultStatus
  if (!isset($Msg)) {
   if ($PosSimEmp==="N") {
    $valeur_init['NumOrd']="";$valeur_init['MntEmprunt']="";$valeur_init['TauxIntAnn']="";$valeur_init['TauxAssAnn']="";
    $valeur_init['PerRbt']="";$valeur_init['NbPer']="";$valeur_init['MntRbtPer']="";$valeur_init['MntAssPer']="";
    $valeur_init['MntRbtTot']="";$valeur_init['MntCout']="";$valeur_init['TauxCoutEmprunt']="";
    $valeur_init['PremEch']="";$Comment="";
   } else {
    $valeur_init['NumOrd']=$SimulEmprunt['NumOrd'];
    $valeur_init['MntEmprunt']=$SimulEmprunt['MntEmprunt'];
    $valeur_init['TauxIntAnn']=$SimulEmprunt['TauxIntAnn'];
    $valeur_init['TauxAssAnn']=$SimulEmprunt['TauxAssAnn'];
    $valeur_init['PerRbt']=$SimulEmprunt['PerRbt'];
    $valeur_init['NbPer']=$SimulEmprunt['NbPer'];
    $valeur_init['MntRbtPer']=$SimulEmprunt['MntRbtPer'];
    $valeur_init['MntAssPer']=$SimulEmprunt['MntAssPer'];
    if ($SimulEmprunt['MntEmprunt']!=0) {
     $valeur_init['MntRbtTot']=round($SimulEmprunt['MntRbtPer']*100+$SimulEmprunt['MntAssPer']*100)*$SimulEmprunt['NbPer']/100;
     $valeur_init['MntCout']=round(($valeur_init['MntRbtTot']-$SimulEmprunt['MntEmprunt'])*100)/100;
     $valeur_init['TauxCoutEmprunt']=round($valeur_init['MntRbtTot']/$SimulEmprunt['MntEmprunt']*10000)/100;
    }
    ($SimulEmprunt['PremEch']=="0000-00-00") ? $valeur_init['PremEch']="" : $valeur_init['PremEch']=invDate($SimulEmprunt['PremEch'],"-","JMAA");
    $Comment=$SimulEmprunt['Comment'];
   }
  }
?> 
<HTML>
<HEAD>
<TITLE>Simulation d'emprunt</TITLE>
<META name="description" content="Simulation d'emprunt">
<META name="keywords" content="">
<LINK rel="stylesheet" type="TEXT/CSS" href="EasyStyle.css">
<script language="javascript"> 
<?php include("./Includes/ControleDate.js");  //ControleDate(d) : Contrle du format JJ-MM-AAAA de la date d
?>
/* ---------------------------------------------------------------------------------------- */
/* Contrle de la saisie des donnes                                                        */
/* ---------------------------------------------------------------------------------------- */
function control_saisie(form,bouton) {
 if (form.Mode.value=="A") return true;
 if (form.Mode.value=="S") return window.confirm("Confirmez-vous la suppression de cette simulation ?");

 if (form.TauxAssAnn.value.replace(RegExp(" ","g"),"")=="") form.TauxAssAnn.value=0;
 if (form.MntAssPer.value.replace(RegExp(" ","g"),"")=="") form.MntAssPer.value=0;

 if (form.NumOrd.value.replace(RegExp(" ","g"),"")=="") {
  alert("Le numro d'ordre de la simulation est une information  saisir obligatoirement");
  form.NumOrd.focus();
  return false;
 }
 if ((form.NumOrd.value.indexOf('\'')!=-1) || (form.NumOrd.value.indexOf('\\')!=-1)) {
  alert("Le numro d'ordre de la simulation contient un caractre spcial interdit, une apostrophe ou un \\ peut-tre.")
  form.NumOrd.focus()
  return false
 }
 if (bouton!="MntEmprunt") {   /* contrler la saisie du montant de l'emprunt */
  if (form.MntEmprunt.value.replace(RegExp(" ","g"),"")=="") {
   alert("Le montant de l'emprunt est une information  saisir obligatoirement");
   form.MntEmprunt.focus();
   return false;
  }
  if (isNaN(form.MntEmprunt.value)) {
   alert("Le montant de l'emprunt doit tre une information numrique")
   form.MntEmprunt.focus();
   return false
  }
 }
 if (bouton!="TauxIntAnn") {     /* contrler la saisie du taux d'intrt */
  if (form.TauxIntAnn.value.replace(RegExp(" ","g"),"")=="") {
   alert("Le taux d'intrt annuel est une information  saisir obligatoirement");
   form.TauxIntAnn.focus();
   return false;
  }
  if (isNaN(form.TauxIntAnn.value)) {
   alert("Le taux d'intrt annuel doit tre une information numrique")
   form.TauxIntAnn.focus();
   return false
  }
 }
 if (bouton!="TauxAssAnn") {     /* contrler la saisie du taux d'intrt */
  if (form.TauxAssAnn.value.replace(RegExp(" ","g"),"")=="") form.TauxAssAnn.value=0;
  if (isNaN(form.TauxAssAnn.value)) {
   alert("Le taux de frais annexes annuel doit tre une information numrique")
   form.TauxAssAnn.focus();
   return false
  }
 }
 if (form.PerRbt.value.replace(RegExp(" ","g"),"")=="") {
  alert("La priodicit est une information  slectionner obligatoirement");
  form.PerRbt.focus();
  return false;
 }
 if (bouton!="NbPer") {     /* contrler la saisie du nombre de priodes */
  if (form.NbPer.value.replace(RegExp(" ","g"),"")=="") {
   alert("Le nombre de priodes est une information  saisir obligatoirement");
   form.NbPer.focus();
   return false;
  }
  if (isNaN(form.NbPer.value)) {
   alert("Le nombre de priodes doit tre une information numrique")
   form.NbPer.focus();
   return false
  }
  form.NbPer.value=parseInt(form.NbPer.value);
  if (form.NbPer.value==0) {
   alert("Le nombre de priodes doit tre diffrent de zro")
   form.NbPer.focus();
   return false
  }
 }
 if (bouton!="MntAssPer") {     /* contrler la saisie des frais financiers fixes */
  if (isNaN(form.MntAssPer.value)) {
   alert("Le montant des frais fixes annexes doit tre une information numrique")
   form.MntAssPer.focus();
   return false
  }
 }
 if (bouton!="MntRbtPer") {   /* contrler la saisie du montant du remboursement priodique */
  if (form.MntRbtPer.value.replace(RegExp(" ","g"),"")=="") {
   alert("Le montant du remboursement priodique est une information  saisir obligatoirement");
   form.MntRbtPer.focus();
   return false;
  }
  if (isNaN(form.MntRbtPer.value)) {
   alert("Le montant du remboursement priodique doit tre une information numrique")
   form.MntRbtPer.focus();
   return false
  }
 }

 if (form.TauxIntAnn.value==0) {
  alert("Le taux d'intrt annuel ne doit pas tre gal  zro");
  form.TauxIntAnn.focus();
  return false;
 }
 if (bouton=="MntEmprunt") {
  x=1+(parseFloat(form.TauxIntAnn.value)+parseFloat(form.TauxAssAnn.value))/form.PerRbt.value/100
  y=(1-1/Math.pow(x,form.NbPer.value))/(x-1) 
  form.MntEmprunt.value=Math.round(form.MntRbtPer.value*y*100)/100
 }
 if (bouton=="MntRbtPer" || bouton=="") {
  x=1+(parseFloat(form.TauxIntAnn.value)+parseFloat(form.TauxAssAnn.value))/form.PerRbt.value/100
  y=(1-1/Math.pow(x,form.NbPer.value))/(x-1) 
  form.MntRbtPer.value=Math.round((form.MntEmprunt.value/y)*100)/100
 }
 if (bouton=="NbPer") {
  if (form.MntEmprunt.value==0) {
   alert("Le montant de l'emprunt ne doit pas tre gal  zro");
   form.MntEmprunt.focus();
   return false;
  }
  x=1+(parseFloat(form.TauxIntAnn.value)+parseFloat(form.TauxAssAnn.value))/form.PerRbt.value/100
  form.NbPer.value=Math.round(Math.log(form.MntRbtPer.value/(form.MntRbtPer.value-(x-1)*form.MntEmprunt.value))/Math.log(x)*100)/100
 }
 form.MntRbtTot.value=Math.round(parseFloat(form.MntRbtPer.value)*100+parseFloat(form.MntAssPer.value)*100)*form.NbPer.value/100 
 form.MntCout.value=Math.round((form.MntRbtTot.value-form.MntEmprunt.value)*100)/100
 if (form.MntEmprunt.value!=0) form.TauxCoutEmprunt.value=Math.round(form.MntRbtTot.value/form.MntEmprunt.value*10000)/100

 if (form.PremEch.value!="" & !ControleDate(form.PremEch.value)) {
  alert("La date de premire chance est une information  saisir au format JJ-MM-AAAA et doit tre ultrieure au 01-01-1970.");
  form.PremEch.focus();
  return false;
 }
 if (form.Mode.value=="R") {
  if (form.PremEch.value.replace(RegExp(" ","g"),"")=="") {
   alert("La saisie d'une date de premire chance est obligatoire en cas de rattachement  un compte");
   form.PremEch.focus();
   return false;
  }
  if (form.IdCpt.value=="") {
   alert("La slection d'un compte de rattachement est obligatoire");
   form.IdCpt.focus();
   return false;
  }
 }
 return true;
}
</script>
</HEAD>
<BODY onLoad="top.document.title='Simulation d\'emprunt';window.defaultStatus='<?php echo $Status; ?>'">
<table border=0 cellspacing=0 cellpadding=0> <!----- Directives d'entte ----->
 <tr>
  <td class=tdleft>
   <?php if ($PosSimEmp>0 and $PosSimEmp!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosSimEmp=<?php echo ($PosSimEmp-1); ?>" title="Accder  la simulation prcdente">Prcdent</a><?php
      } else echo "Prcdent"; ?></td>
  <td class=tdleft>
   <?php if ($PosSimEmp<count($_SESSION['SimulsEmprunt'])-1 and $PosSimEmp!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosSimEmp=<?php echo ($PosSimEmp+1); ?>" title="Accder  la simulation suivante">Suivant</a><?php
      } else echo "Suivant"; ?></td>
  <td class=tdleft>
   <?php if ($PosSimEmp!=="N") { ?>
       <a href="<?php echo $_SERVER['PHP_SELF']; ?>?PosSimEmp=N" title="Crer une simulation">Nouveau</a><?php
      } else echo "Nouveau"; ?></td>
  <td class=tdleft>
   <a href="SimulsEmprunt.php" title="Retour  la liste des simulations">Retour</a></td>
  <td class=tdleft>
   <a href="Help/SimulationEmprunt_hlp.htm" title="De quoi s'agit-il ?" target="_blank">Aide</a></td>
<?php include("./Includes/Aproposde.php"); ?></tr>    <!-- Bote de message A propos de -->
</table>                                                   <!-- Fin de directives d'entte -->
<hr size=2 width="100%"><!----------------------------------------------------------->

<!-- Dbut du formulaire ---------------------------------------------------------------------->
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" onSubmit="return control_saisie(this,' ')">
<input type="hidden" name="PosSimEmp" value="<?php echo $PosSimEmp; ?>"> <!-- Transmission  SimulEmprunt_save.php -->
<input type="hidden" name="Mode" value=""> <!-- = "S" si bouton Supprimer activ, "A" si Annuler -->
<table border=0 cellspacing=0 cellpadding=0> <!------------ Zones de saisie ----------------->
 <tr>
  <td class=tdleft>Numro d'ordre</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="NumOrd" SIZE="6" maxlength="5" value="<?php echo $valeur_init['NumOrd']; ?>"
    onMouseOver="javascript:window.status='Identifiant de la simulation'"></td></tr>
 <tr>
  <td class=tdleft>Montant de l'emprunt</td>
  <td class=tdleft>
   <INPUT TYPE="TEXT" style="text-align:right" name="MntEmprunt" SIZE="11" maxlength="11" value="<?php echo $valeur_init['MntEmprunt']; ?>"
    onMouseOver="javascript:window.status='Montant de l\'emprunt'">&nbsp;&nbsp;&nbsp;
   <INPUT type="button" name="calMntEmprunt" value="Calculer"
    onMouseOver="javascript:window.status='Calcul du montant de l\'emprunt'"
    onClick="Mode.value='';control_saisie(this.form,'MntEmprunt')"></td></tr>
 <tr>
  <td class=tdleft>Taux d'intrt annuel</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" style="text-align:right" name="TauxIntAnn" SIZE="11" maxlength="11" value="<?php echo $valeur_init['TauxIntAnn']; ?>"
    onMouseOver="javascript:window.status='Taux d\'intrt sur l\'anne'">%</td></tr>
 <tr>
  <td class=tdleft>Taux de frais annexes annuel</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" style="text-align:right" name="TauxAssAnn" SIZE="11" maxlength="11" value="<?php echo $valeur_init['TauxAssAnn']; ?>"
    onMouseOver="javascript:window.status='Taux de frais annexes sur l\'anne'">%</td></tr>
 <tr>
  <td class=tdleft>Priodicit du remboursement</td>
  <td class=tdleft> 
   <select name="PerRbt" 
    onMouseOver="javascript:window.status='La slection d\'une priodicit de remboursement est obligatoire'">
	<option value="12" <?php if ($valeur_init['PerRbt']=="12") echo "selected"; ?>>mensuelle</option>
    <option value="4" <?php if ($valeur_init['PerRbt']=="4") echo "selected"; ?>>trimestrielle</option>
	<option value="2" <?php if ($valeur_init['PerRbt']=="2") echo "selected"; ?>>semestrielle</option>
    <option value="1" <?php if ($valeur_init['PerRbt']=="1") echo "selected"; ?>>annuelle</option>
   </select></td></tr>
 <tr>
  <td class=tdleft>Nombre de priodes</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" style="text-align:right" name="NbPer" SIZE="11" maxlength="11" value="<?php echo $valeur_init['NbPer']; ?>"
    onMouseOver="javascript:window.status='Nombre de priodes de remboursement'">&nbsp;&nbsp;&nbsp;
   <input type="button" name="calNbPer" value="Calculer"
    onMouseOver="javascript:window.status='Calcul du nombre de priodes de remboursement'"
    onClick="Mode.value='';control_saisie(this.form,'NbPer')"></td></tr>
 <tr>
  <td class=tdleft>Montant du remboursement priodique</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" style="text-align:right" name="MntRbtPer" SIZE="11" maxlength="11" value="<?php echo $valeur_init['MntRbtPer']; ?>"
    onMouseOver="javascript:window.status='Montant rembours  chaque priode'">&nbsp;&nbsp;&nbsp;
   <input type="button" name="calMntRbtPer" value="Calculer"
    onMouseOver="javascript:window.status='Calcul du montant du remboursement priodique'"
    onClick="Mode.value='';control_saisie(this.form,'MntRbtPer')"></td></tr>
 <tr>
  <td class=tdleft>Frais financiers fixes priodiques</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" style="text-align:right" name="MntAssPer" SIZE="11" maxlength="11" value="<?php echo $valeur_init['MntAssPer']; ?>"
    onMouseOver="javascript:window.status='Montant des frais fixes pour chaque priode'"></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Remboursement total</td>
  <td class=tdleft>
   <INPUT TYPE="TEXT" style="text-align:right" name="MntRbtTot" SIZE="11" value="<?php echo number_format($valeur_init['MntRbtTot'],2,"."," "); ?>" readonly></td></tr>
 <tr>
  <td class=tdleft>Cot de l'emprunt</td>
  <td class=tdleft>
   <INPUT TYPE="TEXT" style="text-align:right" name="MntCout" SIZE="11" value="<?php echo number_format($valeur_init['MntCout'],2,"."," "); ?>" readonly></td></tr>
 <tr>
  <td class=tdleft>Montant rembours / emprunt</td>
  <td class=tdleft>
   <INPUT TYPE="TEXT" style="text-align:right" name="TauxCoutEmprunt" SIZE="11" value="<?php echo $valeur_init['TauxCoutEmprunt']; ?>" readonly>%</td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Commentaires</td>
  <td class=tdleft>
   <TEXTAREA name="Comment" ROWS="3" COLS="40" 
    onMouseOver="javascript:window.status='Texte libre facultatif'"><?php echo $Comment; ?></TEXTAREA></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Date de premire chance</td>
  <td class=tdleft> 
   <INPUT TYPE="TEXT" name="PremEch" SIZE="12" maxlength="10" value="<?php echo $valeur_init['PremEch']; ?>"
    onMouseOver="javascript:window.status='Date du premier remboursement (saisie facultative)'">&nbsp;&nbsp;&nbsp;
   <?php if ($PosSimEmp!=="N") echo "<a href=\"EcheancierRemboursement.php?PosSimEmp=$PosSimEmp\">Simuler l'chancier de remboursement</a>"; ?></td></tr>
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class=tdleft>Compte de rattachement</td>
  <td class=tdleft>
   <select name="IdCpt" 
    onMouseOver="javascript:window.status='La slection d\'un compte d\'emprunt permet d\'y rattacher les chances de remboursement'">
	<option value="">non dtermin</option><?php
     while($Compte=mysqli_fetch_array($rsCompte,MYSQLI_ASSOC)) { ?>
       <option value="<?php echo $Compte['IdCpt']; ?>"><?php echo $Compte['IntCpt']; ?></option><?php
     } ?>
   </select>&nbsp;&nbsp;&nbsp;
   <button type="submit" name="Rattacher" <?php if ($PosSimEmp==="N") echo "disabled"; ?> onClick="Mode.value='R'"
    onMouseOver="javascript:window.status='Demande de cration de l\'chancier de remboursement'">Rattacher</button></td></tr>
</table>
<table border=0 cellspacing=0 cellpadding=0 width="100%"> <!---------- Boutons de commande ----------> 
 <tr><td>&nbsp</td></tr>
 <tr>
  <td class="tdbutton"><input type="submit" value="Enregistrer" onClick="Mode.value='V'"
    onMouseOver="javascript:window.status='Sauvegarde des caractristiques de la simulation'"></td>
  <td class="tdbutton"><button type="submit" name="Annuler" onClick="Mode.value='A'"
    onMouseOver="javascript:window.status='Annulation des modifications de la simulation'">Annuler</button></td>
  <td class="tdbutton"><button type="submit" name="Supprimer" <?php if ($PosSimEmp==="N") echo "disabled"; ?> onClick="Mode.value='S'"
    onMouseOver="javascript:window.status='Demande de suppression de la simulation'">Supprimer</button></td>
  <td class="tdbutton" width="100%"></td>
 </tr>
</table> <!-------------- Fin des boutons de commande ------------------>
<?php if (isset($Msg)) { ?>
 <p class=msg>&nbsp;<?php echo $Msg; ?></p>
<?php } ?>
</form>  <!-------------- Fin de formulaire           ------------------>
</body>
</html>
